/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.jei.common;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.jei.common.Common;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.Services;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;

class JeiRecipeModIngredientConverter
implements RecipeModIngredientConverter {
    JeiRecipeModIngredientConverter() {
    }

    public Optional<PlatformResourceKey> convertToResource(Object ingredient) {
        Optional<FluidResource> fluid = Common.getPlatform().convertJeiIngredientToFluid(ingredient);
        if (fluid.isPresent()) {
            return fluid.map(f -> f);
        }
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return Optional.of(ItemResource.ofItemStack((ItemStack)itemStack));
        }
        return Optional.empty();
    }

    public Optional<ResourceAmount> convertToResourceAmount(Object ingredient) {
        Optional<ResourceAmount> fluid = Common.getPlatform().convertJeiIngredientToFluidAmount(ingredient);
        if (fluid.isPresent()) {
            return fluid;
        }
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return Optional.of(new ResourceAmount((ResourceKey)ItemResource.ofItemStack((ItemStack)itemStack), (long)itemStack.getCount()));
        }
        return Optional.empty();
    }

    public Optional<Object> convertToIngredient(PlatformResourceKey resource) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            return Optional.of(itemResource.toItemStack());
        }
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            IPlatformFluidHelperInternal fluidHelper = Services.PLATFORM.getFluidHelper();
            return Optional.of(fluidHelper.create((Holder)fluidResource.fluid().builtInRegistryHolder(), fluidHelper.bucketVolume(), fluidResource.components()));
        }
        return Optional.empty();
    }
}

