/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.client.render;

import com.hollingsworth.ars_creo.common.block.StarbuncleWheelBlock;
import com.hollingsworth.ars_creo.common.block.StarbuncleWheelTile;
import com.hollingsworth.ars_creo.common.registry.ModBlockRegistry;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class StarbuncleWheelModel
extends GeoModel<StarbuncleWheelTile> {
    static final ResourceLocation model = ResourceLocation.fromNamespaceAndPath((String)"ars_creo", (String)"geo/starbuncle_wheel.geo.json");
    static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"ars_creo", (String)"textures/block/starbuncle_wheel.png");
    static final ResourceLocation animations = ResourceLocation.fromNamespaceAndPath((String)"ars_creo", (String)"animations/starbuncle_wheel_animation.json");

    public void setCustomAnimations(StarbuncleWheelTile entity, long uniqueID, AnimationState<StarbuncleWheelTile> customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        GeoBone head = this.getAnimationProcessor().getBone("wheel");
        Direction facing = (Direction)entity.getBlockState().getValue((Property)StarbuncleWheelBlock.FACING);
        float angle = StarbuncleWheelModel.getAngleForTe((KineticBlockEntity)entity, entity.getBlockPos(), ((StarbuncleWheelBlock)((Object)ModBlockRegistry.STARBY_WHEEL.get())).getRotationAxis(entity.getBlockState()));
        if (facing == Direction.SOUTH || facing == Direction.EAST) {
            angle = -angle;
        }
        head.setRotY(angle);
    }

    public static float getAngleForTe(KineticBlockEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.getLevel());
        float offset = StarbuncleWheelModel.getRotationOffsetForPosition(te, pos, axis);
        return (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    protected static float getRotationOffsetForPosition(KineticBlockEntity te, BlockPos pos, Direction.Axis axis) {
        float offset = ICogWheel.isLargeCog((BlockState)te.getBlockState()) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.getX()) + (axis == Direction.Axis.Y ? 0 : pos.getY()) + (axis == Direction.Axis.Z ? 0 : pos.getZ())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    public ResourceLocation getModelResource(StarbuncleWheelTile object) {
        return model;
    }

    public ResourceLocation getTextureResource(StarbuncleWheelTile object) {
        return texture;
    }

    public ResourceLocation getAnimationResource(StarbuncleWheelTile animatable) {
        return animations;
    }
}

