/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.network;

import com.hollingsworth.ars_creo.network.PacketUpdateJarContraption;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class ACNetworking {
    private static int ID = 0;

    public static int nextID() {
        return ID++;
    }

    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar reg = event.registrar("1");
        reg.playToClient(PacketUpdateJarContraption.TYPE, PacketUpdateJarContraption.CODEC, ACNetworking::handle);
    }

    public static <T extends AbstractPacket> void handle(T message, IPayloadContext ctx) {
        if (ctx.flow().getReceptionSide() == LogicalSide.SERVER) {
            ACNetworking.handleServer(message, ctx);
        } else {
            ClientMessageHandler.handleClient(message, ctx);
        }
    }

    private static <T extends AbstractPacket> void handleServer(T message, IPayloadContext ctx) {
        MinecraftServer server = ctx.player().getServer();
        message.onServerReceived(server, (ServerPlayer)ctx.player());
    }

    public static void sendToNearbyClient(Level world, BlockPos pos, CustomPacketPayload toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)ws, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)toSend, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToNearbyClient(Level world, Entity e, CustomPacketPayload toSend) {
        ACNetworking.sendToNearbyClient(world, e.blockPosition(), toSend);
    }

    public static void sendToPlayerClient(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload msg) {
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static class ClientMessageHandler {
        private ClientMessageHandler() {
        }

        public static <T extends AbstractPacket> void handleClient(T message, IPayloadContext ctx) {
            Minecraft minecraft = Minecraft.getInstance();
            message.onClientReceived(minecraft, (Player)minecraft.player);
        }
    }
}

