/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.blocks.FlaxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlaxBlockUpper
extends Block {
    private static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public FlaxBlockUpper(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES_TOP[(Integer)state.getValue((Property)AGE)];
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && this.isValidLowerStage(facingState)) {
            int ageBelow = (Integer)facingState.getValue((Property)FlaxBlock.AGE);
            if (ageBelow >= 4) {
                int targetAge = ageBelow - 4;
                if ((Integer)stateIn.getValue((Property)AGE) != targetAge) {
                    return (BlockState)stateIn.setValue((Property)AGE, (Comparable)Integer.valueOf(targetAge));
                }
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.isValidLowerStage(worldIn.getBlockState(pos.below()));
    }

    public boolean isValidLowerStage(BlockState state) {
        return state.getBlock() instanceof FlaxBlock;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{AGE});
    }
}

