/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.hourglass;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record HourglassTimeData(HolderSet<Item> dusts, int duration, int light, Optional<ResourceLocation> texture, int ordering) {
    public static final HourglassTimeData EMPTY = new HourglassTimeData((HolderSet<Item>)HolderSet.direct((Holder[])new Holder[0]), 0, 0, Optional.empty(), 99);
    public static final Codec<HourglassTimeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("items").forGetter(HourglassTimeData::dusts), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(HourglassTimeData::duration), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(HourglassTimeData::light), (App)ResourceLocation.CODEC.optionalFieldOf("texture").forGetter(HourglassTimeData::texture), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("ordering", (Object)0).forGetter(HourglassTimeData::ordering)).apply((Applicative)instance, HourglassTimeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HourglassTimeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.ITEM), h -> h.dusts, (StreamCodec)ByteBufCodecs.INT, HourglassTimeData::duration, (StreamCodec)ByteBufCodecs.INT, HourglassTimeData::light, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), HourglassTimeData::texture, (StreamCodec)ByteBufCodecs.INT, HourglassTimeData::ordering, HourglassTimeData::new);

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation computeTexture(ItemStack i, Level world) {
        if (this.texture.isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer itemRenderer = mc.getItemRenderer();
            BakedModel model = itemRenderer.getModel(i, world, null, 0);
            return model.getParticleIcon().contents().name();
        }
        return this.texture.get();
    }

    public Stream<Holder<Item>> getItems() {
        return this.dusts.stream();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public float getIncrement() {
        return 1.0f / (float)this.duration;
    }
}

