/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;

public class BombItem
extends Item
implements ProjectileItem {
    private final BombEntity.BombType type;
    private final boolean glint;

    public BombItem(Item.Properties builder) {
        this(builder, BombEntity.BombType.NORMAL, false);
    }

    public BombItem(Item.Properties builder, BombEntity.BombType type, boolean glint) {
        super(builder);
        this.type = type;
        this.glint = glint;
    }

    public BombEntity.BombType getType() {
        return this.type;
    }

    public boolean isFoil(ItemStack stack) {
        return !stack.has(DataComponents.CUSTOM_MODEL_DATA) && this.glint;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand handIn) {
        VibeChecker.assertSameLevel(level, player);
        ItemStack itemstack = player.getItemInHand(handIn);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
        if (CommonConfigs.Tools.BOMB_COOLDOWN.get().booleanValue()) {
            player.getCooldowns().addCooldown((Item)this, 30);
        }
        if (!level.isClientSide) {
            BombEntity bombEntity = new BombEntity(level, (LivingEntity)player, this.type);
            float pitch = -10.0f;
            bombEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), pitch, bombEntity.getDefaultShootVelocity(), 1.0f);
            level.addFreshEntity((Entity)bombEntity);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        BombEntity bomb = new BombEntity(level, pos.x(), pos.y(), pos.z(), this.type);
        ItemStack s = stack.copy();
        s.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        bomb.setItem(stack);
        return bomb;
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().power(0.9166667f).uncertainty(6.0f).build();
    }
}

