/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;

public class ServerBoundSetBlackboardPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSetBlackboardPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_set_blackboard"), ServerBoundSetBlackboardPacket::new);
    private final BlockPos pos;
    private final byte[][] pixels;

    public ServerBoundSetBlackboardPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.pixels = new byte[16][16];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = buf.readByteArray();
        }
    }

    public ServerBoundSetBlackboardPacket(BlockPos pos, byte[][] pixels) {
        this.pos = pos;
        this.pixels = pixels;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        for (byte[] pixel : this.pixels) {
            buf.writeByteArray(pixel);
        }
    }

    public void handle(Message.Context context) {
        BlackboardBlockTile board;
        BlockEntity blockEntity;
        BlockPos pos;
        ServerPlayer player;
        Level level;
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).level()).hasChunkAt(pos = this.pos) && (blockEntity = level.getBlockEntity(pos)) instanceof BlackboardBlockTile && (board = (BlackboardBlockTile)blockEntity).tryAcceptingClientPixels(player, this.pixels)) {
            board.setChanged();
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

