/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface BlockPredicate
extends Predicate<BlockState> {
    public static final Codec<BlockPredicate> CODEC = Codec.STRING.xmap(BlockPredicate::create, blockStatePredicate -> {
        if (blockStatePredicate instanceof Tag) {
            Tag tp = (Tag)blockStatePredicate;
            return "#" + String.valueOf(tp.tag.location());
        }
        if (blockStatePredicate instanceof Block) {
            Block bp = (Block)blockStatePredicate;
            return bp.id.toString();
        }
        throw new IllegalArgumentException("Must either be Tag or Block predicate");
    });

    @NotNull
    public static BlockPredicate create(String s) {
        if (s.startsWith("#")) {
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)s.replace("#", "")));
            return new Tag((TagKey<net.minecraft.world.level.block.Block>)tag);
        }
        ResourceLocation id = ResourceLocation.parse((String)s);
        return new Block(id);
    }

    public record Tag(TagKey<net.minecraft.world.level.block.Block> tag) implements BlockPredicate
    {
        @Override
        public boolean test(BlockState state) {
            return state.is(this.tag);
        }
    }

    public record Block(ResourceLocation id) implements BlockPredicate
    {
        @Override
        public boolean test(BlockState state) {
            return BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).equals((Object)this.id);
        }
    }
}

