/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.BuilderTools;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.builder.blocks.RotateMode;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControlBlock;
import mcjty.rftoolsbuilder.modules.mover.data.VehicleBuilderData;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class VehicleBuilderTileEntity
extends GenericTileEntity {
    public static final int SLOT_SPACE_CARD = 0;
    public static final int SLOT_VEHICLE_CARD = 1;
    @GuiValue
    private String vehicleName = "";
    @GuiValue
    public static final Value<VehicleBuilderTileEntity, String> VALUE_ROTATE = Value.createEnum((String)"rotate", (NamedEnum[])RotateMode.values(), VehicleBuilderTileEntity::getRotate, VehicleBuilderTileEntity::setRotate);
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BuilderModule.SPACE_CHAMBER_CARD.get()}).in(), 0, 64, 24).slot(SlotDefinition.specific((Item[])new Item[]{(Item)MoverModule.VEHICLE_CARD.get()}).in().out(), 1, 154, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).onUpdate((slot, stack) -> {
        this.vehicleName = stack.getItem() == MoverModule.VEHICLE_CARD.get() ? VehicleCard.getVehicleName(stack) : "";
    }).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<VehicleBuilderTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<VehicleBuilderTileEntity, MenuProvider> screenHandler = tile -> new DefaultContainerProvider("Vehicle Builder").containerSupplier(DefaultContainerProvider.container(MoverModule.CONTAINER_VEHICLE_BUILDER, CONTAINER_FACTORY, (GenericTileEntity)tile)).itemHandler(() -> tile.items).setupSync((GenericTileEntity)tile);
    private static final int MAXDIM = 16;
    @ServerCommand
    public static final Command<?> CMD_CREATE = Command.create((String)"create", (te, player, params) -> te.copyVehicle(player));

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(VehicleBuilderTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    }

    public VehicleBuilderTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.VEHICLE_BUILDER.be().get(), pos, state);
    }

    public GenericItemHandler getItems() {
        return this.items;
    }

    public RotateMode getRotate() {
        return ((VehicleBuilderData)this.getData((AttachmentType)MoverModule.VEHICLE_BUILDER_DATA.get())).rotate();
    }

    public void setRotate(RotateMode rotate) {
        VehicleBuilderData data = ((VehicleBuilderData)this.getData((AttachmentType)MoverModule.VEHICLE_BUILDER_DATA.get())).withRotate(rotate);
        this.setData((AttachmentType)MoverModule.VEHICLE_BUILDER_DATA.get(), data);
    }

    private void copyVehicle(Player player) {
        BlockPos maxCorner;
        BlockPos minCorner;
        SpaceChamberRepository.SpaceChamberChannel chamberChannel;
        ItemStack spaceCard = this.items.getStackInSlot(0);
        ItemStack vehicleCard = this.items.getStackInSlot(1);
        if (VehicleBuilderTileEntity.isUsableSpaceCard(spaceCard) && VehicleBuilderTileEntity.isVehicleCard(vehicleCard) && (chamberChannel = BuilderTools.getSpaceChamberChannel(this.level, spaceCard)) != null && this.checkValid(player, minCorner = chamberChannel.getMinCorner(), maxCorner = chamberChannel.getMaxCorner())) {
            ResourceKey<Level> dimension = chamberChannel.getDimension();
            ServerLevel world = LevelTools.getLevel((Level)this.level, dimension);
            Map<BlockState, List<Integer>> blocks = this.getBlocks(minCorner, maxCorner, world);
            VehicleCard.storeVehicleInCard(vehicleCard, blocks, this.vehicleName);
        }
    }

    @NotNull
    private Map<BlockState, List<Integer>> getBlocks(BlockPos minCorner, BlockPos maxCorner, ServerLevel world) {
        int z;
        int y;
        int x;
        BlockPos realMin;
        Rotation rotation;
        HashMap<BlockState, List<Integer>> blocks = new HashMap<BlockState, List<Integer>>();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(0, 0, 0);
        switch (this.getRotate()) {
            default: {
                throw new MatchException(null, null);
            }
            case ROTATE_0: {
                Rotation rotation2 = Rotation.NONE;
                break;
            }
            case ROTATE_90: {
                Rotation rotation2 = Rotation.CLOCKWISE_90;
                break;
            }
            case ROTATE_180: {
                Rotation rotation2 = Rotation.CLOCKWISE_180;
                break;
            }
            case ROTATE_270: {
                Rotation rotation2 = rotation = Rotation.COUNTERCLOCKWISE_90;
            }
        }
        if (rotation == Rotation.NONE) {
            realMin = minCorner;
        } else {
            realMin = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            for (x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
                mpos.setX(x);
                for (y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                    mpos.setY(y);
                    for (z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                        mpos.setZ(z);
                        BlockPos rotated = mpos.rotate(rotation);
                        realMin = new BlockPos(Math.min(realMin.getX(), rotated.getX()), Math.min(realMin.getY(), rotated.getY()), Math.min(realMin.getZ(), rotated.getZ()));
                    }
                }
            }
        }
        for (x = minCorner.getX(); x <= maxCorner.getX(); ++x) {
            mpos.setX(x);
            for (y = minCorner.getY(); y <= maxCorner.getY(); ++y) {
                mpos.setY(y);
                for (z = minCorner.getZ(); z <= maxCorner.getZ(); ++z) {
                    BlockPos.MutableBlockPos p;
                    mpos.setZ(z);
                    BlockState state = world.getBlockState((BlockPos)mpos);
                    if (state.isAir()) continue;
                    if (rotation != Rotation.NONE) {
                        if (state.getBlock() instanceof MoverControlBlock) {
                            System.out.println("Before: " + String.valueOf(state) + ", Rotation: " + String.valueOf(rotation));
                        }
                        if ((state = state.rotate(rotation)).getBlock() instanceof MoverControlBlock) {
                            System.out.println("After: " + String.valueOf(state));
                        }
                        p = mpos.rotate(rotation);
                    } else {
                        p = mpos;
                    }
                    blocks.computeIfAbsent(state, s -> new ArrayList()).add(VehicleCard.convertPosToInt(realMin, (BlockPos)p));
                }
            }
        }
        return blocks;
    }

    private void rotatePos(BlockPos.MutableBlockPos pos, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                break;
            }
            case CLOCKWISE_90: {
                pos.set(-pos.getZ(), pos.getY(), pos.getX());
                break;
            }
            case CLOCKWISE_180: {
                pos.set(-pos.getX(), pos.getY(), -pos.getZ());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                pos.set(pos.getZ(), pos.getY(), -pos.getX());
            }
        }
    }

    private boolean checkValid(Player player, BlockPos minCorner, BlockPos maxCorner) {
        if (maxCorner.getX() - minCorner.getX() >= 16) {
            player.sendSystemMessage((Component)ComponentFactory.literal((String)"Space chamber too large (max 16x16x16)!"));
            return false;
        }
        if (maxCorner.getY() - minCorner.getY() >= 16) {
            player.sendSystemMessage((Component)ComponentFactory.literal((String)"Space chamber too large (max 16x16x16)!"));
            return false;
        }
        if (maxCorner.getZ() - minCorner.getZ() >= 16) {
            player.sendSystemMessage((Component)ComponentFactory.literal((String)"Space chamber too large (max 16x16x16)!"));
            return false;
        }
        return true;
    }

    public static boolean isUsableSpaceCard(ItemStack stack) {
        if (stack.getItem() != BuilderModule.SPACE_CHAMBER_CARD.get()) {
            return false;
        }
        return BuilderTools.getChannel(stack) != null;
    }

    public static boolean isVehicleCard(ItemStack stack) {
        return stack.getItem() == MoverModule.VEHICLE_CARD.get();
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.items.save(tag, "items", provider);
    }

    public void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.items.load(tag, "items", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        VehicleBuilderData vehicleBuilderData = (VehicleBuilderData)input.get(MoverModule.ITEM_VEHICLE_BUILDER_DATA);
        if (vehicleBuilderData != null) {
            this.setData((Supplier)MoverModule.VEHICLE_BUILDER_DATA, vehicleBuilderData);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        builder.set(MoverModule.ITEM_VEHICLE_BUILDER_DATA, (Object)((VehicleBuilderData)this.getData((Supplier)MoverModule.VEHICLE_BUILDER_DATA)));
    }
}

