/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.inventory;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import com.sts15.enderdrives.db.AEKeyCacheEntry;
import com.sts15.enderdrives.db.EnderDBManager;
import com.sts15.enderdrives.integration.DriveBlockEntityAccessor;
import com.sts15.enderdrives.items.EnderDiskItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class EnderDiskInventory
implements StorageCell {
    private static final Logger LOGGER = LogManager.getLogger((String)"EnderDrives");
    private final ItemStack stack;
    private final int frequency;
    public static final ICellHandler HANDLER = new Handler();
    private final int typeLimit;
    private final boolean disabled;
    private final String scopePrefix;
    private static final boolean DEBUG_LOG = false;
    private static final ThreadLocal<ByteArrayOutputStream> LOCAL_BAOS = ThreadLocal.withInitial(() -> new ByteArrayOutputStream(512));
    private static final ThreadLocal<DataOutputStream> LOCAL_DOS = ThreadLocal.withInitial(() -> new DataOutputStream(LOCAL_BAOS.get()));

    public EnderDiskInventory(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof EnderDiskItem)) {
            throw new IllegalArgumentException("Item is not an EnderDisk!");
        }
        EnderDiskItem item2 = (EnderDiskItem)item;
        this.stack = stack;
        this.frequency = EnderDiskItem.getFrequency(stack);
        this.typeLimit = item2.getTypeLimit();
        this.scopePrefix = EnderDiskItem.getSafeScopePrefix(stack);
        this.disabled = item2.isDisabled(stack);
    }

    public CellState getStatus() {
        if (this.disabled) {
            return CellState.FULL;
        }
        int typesUsed = EnderDBManager.getTypeCount(this.scopePrefix, this.frequency);
        return EnderDiskInventory.calculateCellState(typesUsed, this.typeLimit);
    }

    public static CellState calculateCellState(int typesUsed, int typeLimit) {
        if (typesUsed == 0) {
            return CellState.EMPTY;
        }
        if (typesUsed >= typeLimit) {
            return CellState.FULL;
        }
        float usagePercent = (float)typesUsed / (float)typeLimit;
        return usagePercent >= 0.75f ? CellState.TYPES_FULL : CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        if (this.disabled) {
            return 0.0;
        }
        long totalItems = Math.max(1L, EnderDBManager.getTotalItemCount(this.scopePrefix, this.frequency));
        double base = 100.0;
        double exponent = 0.8;
        double scale = 0.015;
        return base + scale * Math.pow(totalItems, exponent);
    }

    public static CellState getCellStateForStack(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof EnderDiskItem)) {
            return CellState.ABSENT;
        }
        EnderDiskItem enderDiskItem = (EnderDiskItem)item;
        int freq = EnderDiskItem.getFrequency(stack);
        int typesUsed = EnderDBManager.getTypeCount(EnderDiskItem.getSafeScopePrefix(stack), freq);
        int typeLimit = enderDiskItem.getTypeLimit();
        return EnderDiskInventory.calculateCellState(typesUsed, typeLimit);
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        boolean isNewType;
        if (this.disabled) {
            return 0L;
        }
        int transferMode = EnderDiskItem.getTransferMode(this.stack);
        if (transferMode == 2) {
            return 0L;
        }
        if (!(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey itemKey = (AEItemKey)what;
        if (!this.passesFilter(what)) {
            return 0L;
        }
        if (!EnderDBManager.running) {
            EnderDiskInventory.log("DB not ready for inserts.", new Object[0]);
            return 0L;
        }
        ItemStack toInsert = itemKey.toStack();
        byte[] serialized = EnderDiskInventory.serializeItemStackToBytes(toInsert);
        if (serialized.length == 0) {
            return 0L;
        }
        long existing = EnderDBManager.getItemCount(this.scopePrefix, this.frequency, serialized);
        boolean bl = isNewType = existing == 0L;
        if (isNewType && EnderDBManager.getTypeCountInclusive(this.scopePrefix, this.frequency) >= this.typeLimit) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            EnderDBManager.saveItem(this.scopePrefix, this.frequency, serialized, amount);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            server.execute(() -> source.machine().ifPresent(host -> {
                IGrid grid;
                IGridNode node = host.getActionableNode();
                if (node != null && (grid = node.getGrid()) != null) {
                    Set drives = grid.getMachines(DriveBlockEntity.class);
                    block0: for (DriveBlockEntity drive : drives) {
                        for (int i = 0; i < drive.getCellCount(); ++i) {
                            ItemStack stackInSlot = drive.getInternalInventory().getStackInSlot(i);
                            if (stackInSlot.isEmpty() || !(stackInSlot.getItem() instanceof EnderDiskItem)) continue;
                            ((DriveBlockEntityAccessor)drive).enderdrives$triggerVisualUpdate();
                            ((DriveBlockEntityAccessor)drive).enderdrives$recalculateIdlePower();
                            continue block0;
                        }
                    }
                }
            }));
        }
        EnderDiskInventory.log("Insert called: freq=%d scopePrefix=%s amount=%d newType=%s mode=%s", this.frequency, this.scopePrefix, amount, isNewType, mode);
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.disabled) {
            return 0L;
        }
        int transferMode = EnderDiskItem.getTransferMode(this.stack);
        if (transferMode == 1) {
            return 0L;
        }
        if (!(what instanceof AEItemKey)) {
            return 0L;
        }
        AEItemKey itemKey = (AEItemKey)what;
        ItemStack toExtract = itemKey.toStack();
        byte[] serialized = EnderDiskInventory.serializeItemStackToBytes(toExtract);
        if (serialized.length == 0) {
            return 0L;
        }
        long current = EnderDBManager.getItemCount(this.scopePrefix, this.frequency, serialized);
        long toExtractCount = Math.min(current, amount);
        if (toExtractCount > 0L && mode == Actionable.MODULATE) {
            EnderDBManager.saveItem(this.scopePrefix, this.frequency, serialized, -toExtractCount);
            this.stack.setPopTime(5);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            server.execute(() -> source.machine().ifPresent(host -> {
                IGrid grid;
                IGridNode node = host.getActionableNode();
                if (node != null && (grid = node.getGrid()) != null) {
                    Set drives = grid.getMachines(DriveBlockEntity.class);
                    block0: for (DriveBlockEntity drive : drives) {
                        for (int i = 0; i < drive.getCellCount(); ++i) {
                            ItemStack stackInSlot = drive.getInternalInventory().getStackInSlot(i);
                            if (stackInSlot.isEmpty() || !(stackInSlot.getItem() instanceof EnderDiskItem)) continue;
                            ((DriveBlockEntityAccessor)drive).enderdrives$triggerVisualUpdate();
                            ((DriveBlockEntityAccessor)drive).enderdrives$recalculateIdlePower();
                            continue block0;
                        }
                    }
                }
            }));
        }
        EnderDiskInventory.log("Extract called: freq=%d scopePrefix=%s request=%d stored=%d toExtract=%d mode=%s", this.frequency, this.scopePrefix, amount, current, toExtractCount, mode);
        this.getStatus();
        return toExtractCount;
    }

    private boolean passesFilter(AEKey key) {
        ConfigInventory configInv = CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)this.stack);
        for (int i = 0; i < configInv.size(); ++i) {
            AEKey slotKey = configInv.getKey(i);
            if (slotKey == null || !slotKey.equals(key)) continue;
            return true;
        }
        return configInv.keySet().isEmpty();
    }

    public void persist() {
    }

    public Component getDescription() {
        return Component.literal((String)("EnderDisk @ Freq " + this.frequency));
    }

    public void getAvailableStacks(KeyCounter out) {
        List<AEKeyCacheEntry> entries = EnderDBManager.queryItemsByFrequency(this.scopePrefix, this.frequency);
        for (AEKeyCacheEntry entry : entries) {
            out.add((AEKey)entry.aeKey(), entry.count());
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        if (!(what instanceof AEItemKey)) {
            return false;
        }
        AEItemKey itemKey = (AEItemKey)what;
        byte[] serialized = EnderDiskInventory.serializeItemStackToBytes(itemKey.toStack());
        if (serialized.length == 0) {
            return false;
        }
        long storedCount = EnderDBManager.getItemCount(this.scopePrefix, this.frequency, serialized);
        return storedCount > 0L;
    }

    public static byte[] serializeItemStackToBytes(ItemStack stack) {
        try {
            RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
            Tag genericTag = stack.save((HolderLookup.Provider)provider);
            if (!(genericTag instanceof CompoundTag)) {
                return new byte[0];
            }
            CompoundTag tag = (CompoundTag)genericTag;
            ByteArrayOutputStream baos = LOCAL_BAOS.get();
            baos.reset();
            DataOutputStream dos = LOCAL_DOS.get();
            dos.flush();
            NbtIo.write((CompoundTag)tag, (DataOutput)dos);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public static ItemStack deserializeItemStackFromBytes(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            CompoundTag tag = NbtIo.read((DataInput)dis);
            dis.close();
            RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
            return ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag).orElse(ItemStack.EMPTY);
        }
        catch (IOException e) {
            return ItemStack.EMPTY;
        }
    }

    public ItemStack getContainerItem() {
        return this.stack;
    }

    private static void log(String format, Object ... args) {
    }

    private static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(ItemStack is) {
            return is != null && is.getItem() instanceof EnderDiskItem;
        }

        @Nullable
        public StorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new EnderDiskInventory(is) : null;
        }
    }
}

