/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.db.EnderDBManager;
import com.sts15.enderdrives.network.NetworkHandler;
import com.sts15.enderdrives.network.packet.UpdateDiskTypeCountPacket;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RequestDiskTypeCountPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<RequestDiskTypeCountPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"request_disk_type_count"));
    private final String scopePrefix;
    private final int frequency;
    private final int typeLimit;
    public static final StreamCodec<FriendlyByteBuf, RequestDiskTypeCountPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.scopePrefix, (StreamCodec)ByteBufCodecs.VAR_INT, p -> p.frequency, (StreamCodec)ByteBufCodecs.VAR_INT, p -> p.typeLimit, RequestDiskTypeCountPacket::new);

    public RequestDiskTypeCountPacket(String scopePrefix, int frequency, int typeLimit) {
        this.scopePrefix = scopePrefix;
        this.frequency = frequency;
        this.typeLimit = typeLimit;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RequestDiskTypeCountPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                int typeCount = EnderDBManager.getTypeCountInclusive(packet.scopePrefix, packet.frequency);
                long totalCount = EnderDBManager.getTotalItemCountInclusive(packet.scopePrefix, packet.frequency);
                List<ItemStack> topStacks = EnderDBManager.getTopStacks(packet.scopePrefix, packet.frequency, 5);
                NetworkHandler.sendToClient(player, new UpdateDiskTypeCountPacket(packet.scopePrefix, packet.frequency, typeCount, packet.typeLimit(), totalCount, topStacks));
            }
        });
    }

    private int typeLimit() {
        return this.typeLimit;
    }
}

