/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.client.ClientConfigCache;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncDisabledDrivesPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncDisabledDrivesPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"sync_disabled_drives"));
    private final int driveBitmask;
    public static final StreamCodec<ByteBuf, SyncDisabledDrivesPacket> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(SyncDisabledDrivesPacket::new, p -> p.driveBitmask);

    public SyncDisabledDrivesPacket(int driveBitmask) {
        this.driveBitmask = driveBitmask;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncDisabledDrivesPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientConfigCache.setDriveBitmask(packet.driveBitmask));
    }
}

