/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.screen;

import com.sts15.enderdrives.config.serverConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public enum FrequencyScope {
    GLOBAL(0, "screen.enderdrives.scope.global"),
    PERSONAL(1, "screen.enderdrives.scope.private"),
    TEAM(2, "screen.enderdrives.scope.team");

    public final int id;
    public final String translationKey;

    private FrequencyScope(int id, String translationKey) {
        this.id = id;
        this.translationKey = translationKey;
    }

    public String translationKey() {
        return this.translationKey;
    }

    public static FrequencyScope fromId(int id) {
        for (FrequencyScope scope : FrequencyScope.values()) {
            if (scope.id != id || !scope.isEnabled()) continue;
            return scope;
        }
        return FrequencyScope.getDefault();
    }

    public boolean isEnabled() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Boolean)serverConfig.SCOPE_GLOBAL_ENABLED.get();
            case 1 -> (Boolean)serverConfig.SCOPE_PRIVATE_ENABLED.get();
            case 2 -> (Boolean)serverConfig.SCOPE_TEAM_ENABLED.get();
        };
    }

    public static FrequencyScope getDefault() {
        String configValue;
        return switch (configValue = ((String)serverConfig.ENDER_DRIVE_DEFAULT_SCOPE.get()).toLowerCase(Locale.ROOT)) {
            case "private", "personal" -> PERSONAL;
            case "team" -> TEAM;
            default -> GLOBAL;
        };
    }

    public static List<FrequencyScope> getEnabledScopes() {
        return Arrays.stream(FrequencyScope.values()).filter(FrequencyScope::isEnabled).toList();
    }

    public int getId() {
        return this.id;
    }
}

