/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.soulplied_energistics;

import appeng.api.AECapabilities;
import appeng.api.behaviors.GenericInternalInventory;
import com.buuz135.industrialforegoingsouls.IndustrialForegoingSouls;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.buuz135.soulplied_energistics.AppliedHelper;
import com.buuz135.soulplied_energistics.cap.InterfaceSoulCap;
import com.buuz135.soulplied_energistics.client.ClientAppliedHelper;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.mojang.logging.LogUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.slf4j.Logger;

@Mod(value="soulplied_energistics")
public class SoulpliedEnergistics {
    public static final String MODID = "soulplied_energistics";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SoulpliedEnergistics(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(e -> {
            if (e.getRegistryKey().equals(Registries.BLOCK)) {
                AppliedHelper.INSTANCE.runRegister();
            }
        });
        EventManager.mod(RegisterCapabilitiesEvent.class, (EventPriority)EventPriority.LOWEST).process(event -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                if (!event.isBlockRegistered(AECapabilities.GENERIC_INTERNAL_INV, block)) continue;
                event.registerBlock(SoulCapabilities.BLOCK, (level, pos, state, tile, side) -> {
                    GenericInternalInventory genericInv = (GenericInternalInventory)level.getCapability(AECapabilities.GENERIC_INTERNAL_INV, pos, state, tile, side);
                    if (genericInv != null) {
                        return new InterfaceSoulCap(genericInv);
                    }
                    return null;
                }, new Block[]{block});
            }
        }).subscribe();
        EventManager.forge(ItemTooltipEvent.class).process(event -> {
            if (BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem()).getNamespace().equals("industrialforegoingsouls")) {
                event.getToolTip().add(Component.translatable((String)"soulpliedenergistics.can_be_used_filter").withStyle(ChatFormatting.GRAY));
            }
            if (event.getItemStack().getItem().equals(IndustrialForegoingSouls.SOUL_LASER_BLOCK.asItem())) {
                event.getToolTip().add(Component.translatable((String)"soulpliedenergistics.storage_bus").withStyle(ChatFormatting.GRAY));
            }
        }).subscribe();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AppliedHelper.INSTANCE.init();
    }

    @EventBusSubscriber(modid="soulplied_energistics", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ClientAppliedHelper.INSTANCE.init();
        }
    }
}

