/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.ConverterTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.lang.ref.WeakReference;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class ConverterRenderer
extends VillagerRendererBase<ConverterTileentity> {
    private WeakReference<Zombie> zombieCache = new WeakReference<Object>(null);
    private WeakReference<ZombieRenderer> zombieRendererCache = new WeakReference<Object>(null);
    private WeakReference<ZombieVillagerRenderer> zombieVillagerRendererCache = new WeakReference<Object>(null);
    private WeakReference<ZombieVillager> zombieVillagerCache = new WeakReference<Object>(null);

    public ConverterRenderer(BlockEntityRendererProvider.Context renderer) {
        super(renderer);
    }

    @Override
    public void render(ConverterTileentity converter, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        EasyVillagerEntity villagerEntity;
        ZombieVillager zombieVillager;
        ZombieVillagerRenderer zombieVillagerRenderer;
        Zombie zombie;
        super.render(converter, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay);
        matrixStack.pushPose();
        ZombieRenderer zombieRenderer = (ZombieRenderer)this.zombieRendererCache.get();
        if (zombieRenderer == null) {
            zombieRenderer = new ZombieRenderer(this.createEntityRenderer());
            this.zombieRendererCache = new WeakReference<ZombieRenderer>(zombieRenderer);
        }
        if ((zombie = (Zombie)this.zombieCache.get()) == null) {
            zombie = new Zombie((Level)this.minecraft.level);
            this.zombieCache = new WeakReference<Zombie>(zombie);
        }
        if ((zombieVillagerRenderer = (ZombieVillagerRenderer)this.zombieVillagerRendererCache.get()) == null) {
            zombieVillagerRenderer = new ZombieVillagerRenderer(this.createEntityRenderer());
            this.zombieVillagerRendererCache = new WeakReference<ZombieVillagerRenderer>(zombieVillagerRenderer);
        }
        if ((zombieVillager = (ZombieVillager)this.zombieVillagerCache.get()) == null) {
            zombieVillager = new ZombieVillager(EntityType.ZOMBIE_VILLAGER, (Level)this.minecraft.level);
            this.zombieVillagerCache = new WeakReference<ZombieVillager>(zombieVillager);
        }
        Direction direction = Direction.SOUTH;
        if (!converter.isFakeWorld()) {
            direction = (Direction)converter.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if ((villagerEntity = converter.getVillagerEntity()) != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(-0.3125, 0.0, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            matrixStack.scale(0.4f, 0.4f, 0.4f);
            if (converter.getTimer() >= (long)ConverterTileentity.getZombifyTime() && converter.getTimer() < (long)ConverterTileentity.getConvertTime()) {
                zombieVillager.setVillagerData(villagerEntity.getVillagerData());
                zombieVillager.setBaby(villagerEntity.isBaby());
                zombieVillagerRenderer.render((LivingEntity)zombieVillager, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            } else {
                this.getVillagerRenderer().render((LivingEntity)villagerEntity, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
            }
            matrixStack.popPose();
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.0625, 0.5);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-direction.toYRot()));
        matrixStack.translate(0.3125, 0.0, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        matrixStack.scale(0.4f, 0.4f, 0.4f);
        zombieRenderer.render((LivingEntity)zombie, 0.0f, 1.0f, matrixStack, buffer, combinedLight);
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

