/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.datacomponents;

import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.items.ModItems;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class VillagerBlockEntityData {
    public static final StreamCodec<RegistryFriendlyByteBuf, VillagerBlockEntityData> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, VillagerBlockEntityData>(){

        public VillagerBlockEntityData decode(RegistryFriendlyByteBuf buf) {
            return new VillagerBlockEntityData(buf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf buf, VillagerBlockEntityData be) {
            buf.writeNbt((Tag)be.nbt);
        }
    };
    private WeakReference<FakeWorldTileentity> cache = new WeakReference<Object>(null);
    private WeakReference<FakeWorldTileentity> emptyCache = new WeakReference<Object>(null);
    private final CompoundTag nbt;

    private VillagerBlockEntityData(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public CompoundTag copy() {
        return this.nbt.copy();
    }

    public static VillagerBlockEntityData of(CompoundTag nbt) {
        return new VillagerBlockEntityData(nbt.copy());
    }

    @Nullable
    public static VillagerBlockEntityData get(ItemStack stack) {
        return (VillagerBlockEntityData)stack.get(ModItems.BLOCK_ENTITY_DATA_COMPONENT);
    }

    public <T extends FakeWorldTileentity> T getBlockEntity(HolderLookup.Provider provider, @Nullable Level level, Supplier<T> blockEntitySupplier) {
        if (level == null) {
            FakeWorldTileentity te = (FakeWorldTileentity)((Object)this.emptyCache.get());
            if (te == null) {
                te = (FakeWorldTileentity)((Object)blockEntitySupplier.get());
                this.emptyCache = new WeakReference<FakeWorldTileentity>(te);
            }
            return (T)((Object)te);
        }
        FakeWorldTileentity te = (FakeWorldTileentity)((Object)this.cache.get());
        if (te == null) {
            te = (FakeWorldTileentity)((Object)blockEntitySupplier.get());
            te.setFakeWorld(level);
            te.loadCustomOnly(this.nbt, provider);
            this.cache = new WeakReference<FakeWorldTileentity>(te);
        }
        return (T)((Object)te);
    }

    public static <T extends FakeWorldTileentity> T getAndStoreBlockEntity(ItemStack stack, HolderLookup.Provider provider, @Nullable Level level, Supplier<T> blockEntitySupplier) {
        VillagerBlockEntityData data = VillagerBlockEntityData.get(stack);
        if (data == null) {
            CustomData beData = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
            data = new VillagerBlockEntityData(beData.copyTag());
            stack.set(ModItems.BLOCK_ENTITY_DATA_COMPONENT, (Object)data);
        }
        return data.getBlockEntity(provider, level, blockEntitySupplier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VillagerBlockEntityData be = (VillagerBlockEntityData)o;
        return Objects.equals(this.nbt, be.nbt);
    }

    public int hashCode() {
        return Objects.hashCode(this.nbt);
    }
}

