/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FridgeBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.FreezerBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ProcessingContainerBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FreezerBlock
extends FridgeBlock {
    private static final MapCodec<FridgeBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)MetalType.CODEC.fieldOf("metal_type").forGetter(block -> block.type), (App)FreezerBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.byNameCodec().xmap(block -> () -> block, Supplier::get).fieldOf("fridge").forGetter(block -> ((FreezerBlock)block).fridge)).apply((Applicative)builder, FreezerBlock::new));
    private final Supplier<Block> fridge;

    public FreezerBlock(MetalType type, BlockBehaviour.Properties properties, Supplier<Block> fridge) {
        super(type, properties);
        this.fridge = fridge;
    }

    public Supplier<Block> getFridge() {
        return this.fridge;
    }

    @Override
    protected MapCodec<FridgeBlock> codec() {
        return CODEC;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (((Direction)state.getValue((Property)DIRECTION)).getOpposite() == result.getDirection()) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FreezerBlockEntity) {
                FreezerBlockEntity freezer = (FreezerBlockEntity)blockEntity;
                player.openMenu((MenuProvider)freezer);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos abovePos = context.getClickedPos().above();
        Level level = context.getLevel();
        if (abovePos.getY() < level.getMaxBuildHeight() && level.getBlockState(abovePos).canBeReplaced(context)) {
            return super.getStateForPlacement(context);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockState fridge = (BlockState)this.fridge.get().defaultBlockState().setValue((Property)DIRECTION, (Comparable)((Direction)state.getValue((Property)DIRECTION)));
        level.setBlock(pos.above(), fridge, 3);
        fridge.getBlock().setPlacedBy(level, pos.above(), fridge, entity, stack);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!state.is(newState.getBlock()) && level.getBlockState(pos.above()).getBlock() instanceof FridgeBlock) {
            level.removeBlock(pos.above(), false);
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Services.BLOCK_ENTITY.createFreezerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return FreezerBlock.createTicker(type, (BlockEntityType)ModBlockEntities.FREEZER.get(), ProcessingContainerBlockEntity::serverTick);
        }
        return null;
    }
}

