/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.CeilingFanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CeilingFanBlockEntity
extends ElectricityModuleBlockEntity
implements ILevelAudio {
    public static final float MAX_SPEED = 50.0f;
    private static final float ACCELERATION = 1.25f;
    private static final float RESISTANCE = 0.98f;
    private static final AABB[] DAMAGE_BOXES = (AABB[])Util.make(() -> {
        AABB[] boxes = new AABB[Direction.values().length];
        boxes[Direction.UP.get3DDataValue()] = new AABB(-0.625, 0.5, -0.625, 1.625, 0.625, 1.625);
        boxes[Direction.DOWN.get3DDataValue()] = new AABB(-0.625, 0.375, -0.625, 1.625, 0.5, 1.625);
        boxes[Direction.NORTH.get3DDataValue()] = new AABB(-0.625, -0.625, 0.375, 1.625, 1.625, 0.5);
        boxes[Direction.EAST.get3DDataValue()] = new AABB(0.5, -0.625, -0.625, 0.625, 1.625, 1.625);
        boxes[Direction.SOUTH.get3DDataValue()] = new AABB(-0.625, -0.625, 0.5, 1.625, 1.625, 0.625);
        boxes[Direction.WEST.get3DDataValue()] = new AABB(0.375, -0.625, -0.625, 0.5, 1.625, 1.625);
        return boxes;
    });
    protected final Vec3 audioPosition;
    private float bladeSpeed;
    private float bladeRotation;
    private float lastBladeRotation;

    public CeilingFanBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CEILING_FAN.get(), pos, state);
        this.audioPosition = pos.getCenter().add(0.0, 0.375, 0.0);
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)BlockStateProperties.POWERED) && (Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)BlockStateProperties.POWERED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    private void updateAnimation() {
        this.lastBladeRotation = this.bladeRotation;
        if (this.isNodePowered()) {
            this.bladeSpeed = Math.min(this.bladeSpeed + 1.25f, this.getMaxSpeed());
        }
        this.bladeSpeed *= 0.98f;
        this.bladeRotation += this.bladeSpeed;
        if (this.bladeRotation > 360.0f) {
            this.bladeRotation -= 360.0f;
            this.lastBladeRotation -= 360.0f;
        }
    }

    public float getRotation(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.lastBladeRotation, (float)this.bladeRotation);
    }

    private void performDamage(Level level) {
        if (this.isNodePowered()) {
            Direction direction = this.getDirection();
            AABB box = this.getDamageBox(direction).move(this.getBlockPos());
            List entities = level.getEntitiesOfClass(LivingEntity.class, box);
            entities.forEach(entity -> {
                entity.hurt(Services.BLOCK.ceilingFanDamageSource(level), 0.5f);
                entity.setLastHurtByMob(entity);
            });
        }
    }

    public AABB getDamageBox(Direction direction) {
        return DAMAGE_BOXES[direction.get3DDataValue()];
    }

    public Direction getDirection() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)CeilingFanBlock.FACING)) {
            return (Direction)state.getValue((Property)CeilingFanBlock.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void moduleTick(Level level) {
        super.moduleTick(level);
        if (!level.isClientSide) {
            this.performDamage(level);
        } else {
            this.updateAnimation();
            AudioManager.get().playLevelAudio(this);
        }
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_CEILING_FAN_SPIN.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.bladeSpeed > 5.0f && !this.isRemoved();
    }

    @Override
    public float getAudioVolume() {
        return this.bladeSpeed / 50.0f;
    }

    @Override
    public float getAudioPitch() {
        return 0.5f + this.bladeSpeed / 50.0f;
    }

    @Override
    public int getAudioHash() {
        return this.worldPosition.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return 16.0;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide() && this.isNodePowered()) {
            this.bladeSpeed = this.getMaxSpeed();
        }
    }

    private float getMaxSpeed() {
        return ((Double)Config.CLIENT.ceilingFanMaxSpeed.get()).floatValue();
    }
}

