/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.content.fluid;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import de.melanx.extradisks.ModConfig;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.fluid.ExtraFluidStorageVariant;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ExtraFluidStorageBlockProvider
implements StorageBlockProvider {
    private final ExtraFluidStorageVariant variant;
    private final Component displayName;

    public ExtraFluidStorageBlockProvider(ExtraFluidStorageVariant variant) {
        this.variant = variant;
        this.displayName = Component.translatable((String)("block.extradisks." + variant.getName() + "_fluid_storage_block"));
    }

    @Nonnull
    public SerializableStorage createStorage(@Nonnull Runnable runnable) {
        return StorageTypes.FLUID.create(this.variant.getCapacity(), runnable);
    }

    @Nonnull
    public Component getDisplayName() {
        return this.displayName;
    }

    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case ExtraFluidStorageVariant.TIER_5_FLUID -> ((Integer)ModConfig.fluid_tier5usage.get()).intValue();
            case ExtraFluidStorageVariant.TIER_6_FLUID -> ((Integer)ModConfig.fluid_tier6usage.get()).intValue();
            case ExtraFluidStorageVariant.TIER_7_FLUID -> ((Integer)ModConfig.fluid_tier7usage.get()).intValue();
            case ExtraFluidStorageVariant.TIER_8_FLUID -> ((Integer)ModConfig.fluid_tier8usage.get()).intValue();
            case ExtraFluidStorageVariant.TIER_9_FLUID -> ((Integer)ModConfig.fluid_tier9usage.get()).intValue();
        };
    }

    @Nonnull
    public ResourceFactory getResourceFactory() {
        return RefinedStorageApi.INSTANCE.getFluidResourceFactory();
    }

    @Nonnull
    public BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)Registration.FLUID_STORAGE_TILE.get((Object)this.variant).get();
    }

    @Nonnull
    public MenuType<?> getMenuType() {
        return Menus.INSTANCE.getFluidStorage();
    }
}

