/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.neoforge;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.blf02.neoforge.VRAPIPlugin;
import net.blf02.neoforge.VRAPIPluginProvider;
import net.blf02.vrapi.VRAPIMod;
import net.blf02.vrapi.common.VRAPI;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class APIProviderInit {
    public static void init() {
        APIProviderInit.findPlugins().forEach(provider -> provider.getVRAPI(VRAPI.VRAPIInstance));
    }

    protected static List<VRAPIPluginProvider> findPlugins() {
        return ModList.get().getAllScanData().stream().flatMap(APIProviderInit::findValidAnnotations).map(APIProviderInit::initPlugin).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static Stream<Type> findValidAnnotations(ModFileScanData data) {
        Type annotationType = Type.getType(VRAPIPlugin.class);
        return data.getAnnotations().stream().filter(it -> annotationType.equals((Object)it.annotationType())).map(ModFileScanData.AnnotationData::clazz);
    }

    protected static VRAPIPluginProvider initPlugin(Type type) {
        try {
            Class<?> clazz = Class.forName(type.getClassName(), false, APIProviderInit.class.getClassLoader());
            if (!VRAPIPluginProvider.class.isAssignableFrom(clazz)) {
                throw new ClassCastException(clazz.getName() + " does not implement VRAPIPluginProvider!");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (VRAPIPluginProvider)constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            VRAPIMod.LOGGER.log(Level.WARNING, "Could not initialize plugin " + type.getClassName());
            return null;
        }
    }
}

