/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.neoforge;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.blf02.neoforge.BufferPacket;
import net.blf02.vrapi.client.ClientRegistryAccess;
import net.blf02.vrapi.common.Platform;
import net.blf02.vrapi.common.network.NetworkChannel;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class PlatformImpl
implements Platform {
    public static final List<Object> keyMappingsToRegister = new ArrayList<Object>();

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public void registerKeyBinding(Object keyMapping) {
        keyMappingsToRegister.add(keyMapping);
    }

    @Override
    public <T> void sendToServer(T message, NetworkChannel.NetworkRegistrationData<T> data) {
        try {
            RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), ClientRegistryAccess.get(), ConnectionType.NEOFORGE);
            buffer.writeInt(data.id());
            data.encoder().accept(message, buffer);
            PacketDistributor.sendToServer((CustomPacketPayload)new BufferPacket(buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public <T> void sendToPlayer(ServerPlayer player, T message, NetworkChannel.NetworkRegistrationData<T> data) {
        try {
            RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess(), ConnectionType.NEOFORGE);
            buffer.writeInt(data.id());
            data.encoder().accept(message, buffer);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BufferPacket(buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public void registerClientPostTick(Consumer<Player> ticker) {
        NeoForge.EVENT_BUS.addListener(event -> {
            if (Minecraft.getInstance().player != null) {
                ticker.accept((Player)Minecraft.getInstance().player);
            }
        });
    }

    @Override
    public void registerServerPostTick(Consumer<Player> ticker) {
        NeoForge.EVENT_BUS.addListener(event -> event.getServer().getPlayerList().getPlayers().forEach(ticker));
    }

    @Override
    public void registerClientPlayerQuit(Consumer<Player> quitHandler) {
        NeoForge.EVENT_BUS.addListener(event -> quitHandler.accept((Player)event.getPlayer()));
    }

    @Override
    public void registerOnPlayerJoin(Consumer<ServerPlayer> joinHandler) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                joinHandler.accept(sp);
            }
        });
    }

    @Override
    public void registerOnPlayerDisconnect(Consumer<ServerPlayer> disconnectHandler) {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                disconnectHandler.accept(sp);
            }
        });
    }
}

