/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.vrapi.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import net.blf02.vrapi.VRAPIMod;
import net.blf02.vrapi.common.Plat;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class NetworkChannel {
    private final List<NetworkRegistrationData<?>> packets = new ArrayList();

    public <T> void register(Class<T> clazz, BiConsumer<T, RegistryFriendlyByteBuf> encoder, Function<RegistryFriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
        this.packets.add(new NetworkRegistrationData<T>(this.packets.size(), clazz, encoder, decoder, handler));
    }

    public <T> void sendToServer(T message) {
        NetworkRegistrationData<T> data = this.getData(message);
        Plat.INSTANCE.sendToServer(message, data);
    }

    public <T> void sendToPlayer(ServerPlayer player, T message) {
        NetworkRegistrationData<T> data = this.getData(message);
        Plat.INSTANCE.sendToPlayer(player, message, data);
    }

    public <T> void doReceive(@Nullable ServerPlayer player, RegistryFriendlyByteBuf buffer) {
        Object message;
        NetworkRegistrationData<?> data = this.packets.get(buffer.readInt());
        try {
            message = data.decoder.apply(buffer);
        }
        catch (Exception e) {
            VRAPIMod.LOGGER.log(Level.SEVERE, "Error while decoding packet.", e);
            return;
        }
        data.handler.accept(message, player);
    }

    private <T> NetworkRegistrationData<T> getData(T message) {
        NetworkRegistrationData data = this.packets.stream().filter(d -> d.clazz == message.getClass()).findFirst().orElse(null);
        if (data == null) {
            throw new IllegalArgumentException("Packet type %s not registered!".formatted(message.getClass().getName()));
        }
        return data;
    }

    public record NetworkRegistrationData<T>(int id, Class<T> clazz, BiConsumer<T, RegistryFriendlyByteBuf> encoder, Function<RegistryFriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
    }
}

