/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.vrapi.data;

import net.blf02.vrapi.api.data.IVRData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class VRData
implements IVRData {
    protected final Vec3 position;
    protected final Vec3 lookVec;
    protected final float roll;
    protected final Matrix4f rotMatr;

    public VRData(Vec3 position, Vec3 lookVec, float roll, Matrix4f rotMatr) {
        this.position = position;
        this.lookVec = lookVec;
        this.roll = roll;
        this.rotMatr = rotMatr;
    }

    @Override
    public Vec3 position() {
        return this.position;
    }

    @Override
    public float getRoll() {
        return this.roll;
    }

    @Override
    public float getPitch() {
        return (float)Math.toDegrees(Math.asin(this.lookVec.y / this.lookVec.length()));
    }

    @Override
    public float getYaw() {
        return (float)Math.toDegrees(Math.atan2(-this.lookVec.x, this.lookVec.z));
    }

    @Override
    public Matrix4f getRotationMatrix() {
        if (this.rotMatr == null) {
            throw new IllegalArgumentException("You can only access the rotation matrix from the client side!");
        }
        return this.rotMatr;
    }

    @Override
    public Vec3 getLookAngle() {
        return this.lookVec;
    }

    public static void encode(VRData data, FriendlyByteBuf buffer) {
        buffer.writeDouble(data.position.x).writeDouble(data.position.y).writeDouble(data.position.z);
        buffer.writeDouble(data.lookVec.x).writeDouble(data.lookVec.y).writeDouble(data.lookVec.z);
        buffer.writeFloat(data.roll);
    }

    public static VRData decode(FriendlyByteBuf buffer) {
        Vec3 position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vec3 lookVec = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        float roll = buffer.readFloat();
        return new VRData(position, lookVec, roll, null);
    }

    public String toString() {
        return "Position: " + String.valueOf(this.position) + "\nLook Vector: " + String.valueOf(this.lookVec) + "\nPitch/Yaw/Roll: " + "%f/%f/%f".formatted(Float.valueOf(this.getPitch()), Float.valueOf(this.getYaw()), Float.valueOf(this.getRoll()));
    }
}

