/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen.provider;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.item.RuItems;

public class RuRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public static final Supplier<ImmutableList<ItemLike>> REDSTONE_SMELTABLES = Suppliers.memoize(() -> ImmutableList.of((Object)((ItemLike)RuBlocks.RAW_REDSTONE_BLOCK.get()), (Object)((ItemLike)RuBlocks.REDSTONE_BULB.get())));
    public static final Supplier<ImmutableList<ItemLike>> MOSSY_STONE_SMELTABLES = Suppliers.memoize(() -> ImmutableList.of((Object)Blocks.MOSSY_COBBLESTONE));

    public RuRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> holder) {
        super(output, holder);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PRISMOSS.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.STONE).define(Character.valueOf('X'), (ItemLike)RuBlocks.PRISMOSS_SPROUT.get()).pattern("X").pattern("#").group("prismoss").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.DEEPSLATE_PRISMOSS.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE).define(Character.valueOf('X'), (ItemLike)RuBlocks.PRISMOSS_SPROUT.get()).pattern("X").pattern("#").group("prismoss").unlockedBy("has_deepslate", RuRecipeProvider.has((ItemLike)Blocks.DEEPSLATE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.HANGING_PRISMARITE.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()).pattern("#").pattern("#").pattern("#").group("prismarite").unlockedBy("has_prismarite", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.LARGE_PRISMARITE_CLUSTER.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()).pattern("#").pattern("#").group("prismarite").unlockedBy("has_prismarite", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PRISMAGLASS.get()), (int)2).define(Character.valueOf('#'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"glass"))).define(Character.valueOf('X'), RuTags.PRISMARITE_CRYSTALS_ITEM).pattern(" X ").pattern("X#X").pattern(" X ").group("stained_glass").unlockedBy("has_glass", RuRecipeProvider.has((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"glass")))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RuBlocks.RAW_REDSTONE_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Items.REDSTONE).pattern("##").pattern("##").group("redstone").unlockedBy("has_redstone", RuRecipeProvider.has((ItemLike)Items.REDSTONE)).save(consumer);
        RuRecipeProvider.oreSmelting(consumer, (List)REDSTONE_SMELTABLES.get(), RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, 200, "redstone");
        RuRecipeProvider.oreBlasting(consumer, (List)REDSTONE_SMELTABLES.get(), RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, 100, "redstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RuBlocks.REDSTONE_BUD.get()), (int)2).define(Character.valueOf('#'), (ItemLike)Items.REDSTONE).pattern("###").group("redstone").unlockedBy("has_redstone", RuRecipeProvider.has((ItemLike)Items.REDSTONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.STONE_GRASS_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.STONE).define(Character.valueOf('X'), RuTags.GRASS_ITEM).pattern("X").pattern("#").group("stone_grass").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.DEEPSLATE_GRASS_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE).define(Character.valueOf('X'), RuTags.GRASS_ITEM).pattern("X").pattern("#").group("stone_grass").unlockedBy("has_deepslate", RuRecipeProvider.has((ItemLike)Blocks.DEEPSLATE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.VIRIDESCENT_NYLIUM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.STONE).define(Character.valueOf('X'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms"))).pattern("X").pattern("#").group("viridescent_nylium").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).unlockedBy("has_mushroom", RuRecipeProvider.has((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms")))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE).define(Character.valueOf('X'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms"))).pattern("X").pattern("#").group("viridescent_nylium").unlockedBy("has_deepslate", RuRecipeProvider.has((ItemLike)Blocks.DEEPSLATE)).unlockedBy("has_mushroom", RuRecipeProvider.has((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms")))).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.DEAD_STEPPE_SHRUB.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.SMALL_DESERT_SHRUB.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.ALPHA_DANDELION.get(), "yellow_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.ALPHA_ROSE.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.BLEEDING_HEART.get(), "magenta_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuBlocks.BLUE_LUPINE.get(), "blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)RuBlocks.DAISY.get(), "light_gray_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLACK_DYE, (ItemLike)RuBlocks.DORCEL.get(), "black_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.FELICIA_DAISY.get(), "light_blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.FIREWEED.get(), "magenta_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.GLISTERING_BLOOM.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.HIBISCUS.get(), "yellow_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.MALLOW.get(), "orange_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.HYSSOP.get(), "purple_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_LUPINE.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.POPPY_BUSH.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.SALMON_POPPY_BUSH.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.PURPLE_LUPINE.get(), "purple_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.RED_LUPINE.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.WARATAH.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)RuBlocks.WHITE_TRILLIUM.get(), "white_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.WILTING_TRILLIUM.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.YELLOW_LUPINE.get(), "yellow_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.TSUBAKI.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.RED_SNOWBELLE.get(), "red_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.RED_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.ORANGE_SNOWBELLE.get(), "orange_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.ORANGE_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"orange_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.YELLOW_SNOWBELLE.get(), "yellow_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.YELLOW_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"yellow_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIME_DYE, (ItemLike)RuBlocks.LIME_SNOWBELLE.get(), "lime_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.LIME_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"lime_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.GREEN_DYE, (ItemLike)RuBlocks.GREEN_SNOWBELLE.get(), "green_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.GREEN_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"green_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.CYAN_DYE, (ItemLike)RuBlocks.CYAN_SNOWBELLE.get(), "cyan_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.CYAN_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"cyan_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.LIGHT_BLUE_SNOWBELLE.get(), "light_blue_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.LIGHT_BLUE_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"light_blue_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuBlocks.BLUE_SNOWBELLE.get(), "blue_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.BLUE_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"blue_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.PURPLE_SNOWBELLE.get(), "purple_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.PURPLE_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"purple_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.MAGENTA_SNOWBELLE.get(), "magenta_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.MAGENTA_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"magenta_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_SNOWBELLE.get(), "pink_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.PINK_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"pink_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.BROWN_SNOWBELLE.get(), "brown_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.BROWN_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"brown_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)RuBlocks.WHITE_SNOWBELLE.get(), "white_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.WHITE_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"white_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)RuBlocks.LIGHT_GRAY_SNOWBELLE.get(), "light_gray_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.LIGHT_GRAY_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"light_gray_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.GRAY_DYE, (ItemLike)RuBlocks.GRAY_SNOWBELLE.get(), "gray_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.GRAY_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gray_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLACK_DYE, (ItemLike)RuBlocks.BLACK_SNOWBELLE.get(), "black_dye");
        RuRecipeProvider.snowbelle(consumer, (ItemLike)RuBlocks.BLACK_SNOWBELLE.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"black_dyes")));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.ORANGE_CONEFLOWER.get(), "orange_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.PURPLE_CONEFLOWER.get(), "purple_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.ASTER.get(), "light_blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get(), "light_blue_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get()), (int)6).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_MAGNOLIA_LEAVES.get()).pattern("###").group("multiface_flowers").unlockedBy("has_blue_magnolia_leaves", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_MAGNOLIA_LEAVES.get()))).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_MAGNOLIA_FLOWERS.get(), "pink_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.PINK_MAGNOLIA_FLOWERS.get()), (int)6).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_MAGNOLIA_LEAVES.get()).pattern("###").group("multiface_flowers").unlockedBy("has_pink_magnolia_leaves", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_MAGNOLIA_LEAVES.get()))).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get(), "white_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get()), (int)6).define(Character.valueOf('#'), (ItemLike)RuBlocks.WHITE_MAGNOLIA_LEAVES.get()).pattern("###").group("multiface_flowers").unlockedBy("has_white_magnolia_leaves", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.WHITE_MAGNOLIA_LEAVES.get()))).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuItems.MEADOW_SAGE.get(), "blue_dye");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BARLEY.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)200).unlockedBy("has_barley", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BARLEY.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"barley_smelting"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BARLEY.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)100).unlockedBy("has_barley", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BARLEY.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"barley_smoking"));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.CATTAIL.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)RuBlocks.TASSEL.get(), "light_gray_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.DAY_LILY.get(), "orange_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.ASHEN_SAPLING.get(), (ItemLike)RuBlocks.ASHEN_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.ACACIA_SAPLING, (ItemLike)RuBlocks.ACACIA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.BIRCH_SAPLING, (ItemLike)RuBlocks.BIRCH_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BAOBAB_SAPLING.get(), (ItemLike)RuBlocks.BAOBAB_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BLACKWOOD_SAPLING.get(), (ItemLike)RuBlocks.BLACKWOOD_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BRIMWOOD_SAPLING.get(), (ItemLike)RuBlocks.BRIMWOOD_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.CHERRY_SAPLING, (ItemLike)RuBlocks.CHERRY_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.CACTUS_FLOWER.get(), "magenta_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.MAGNOLIA_SAPLING.get(), (ItemLike)RuBlocks.MAGNOLIA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.CYPRESS_SAPLING.get(), (ItemLike)RuBlocks.CYPRESS_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.DARK_OAK_SAPLING, (ItemLike)RuBlocks.DARK_OAK_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.DEAD_PINE_SAPLING.get(), (ItemLike)RuBlocks.DEAD_PINE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.DEAD_SAPLING.get(), (ItemLike)RuBlocks.DEAD_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.EUCALYPTUS_SAPLING.get(), (ItemLike)RuBlocks.EUCALYPTUS_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.FLOWERING_SAPLING.get(), (ItemLike)RuBlocks.FLOWERING_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.GOLDEN_LARCH_SAPLING.get(), (ItemLike)RuBlocks.GOLDEN_LARCH_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.JOSHUA_SAPLING.get(), (ItemLike)RuBlocks.JOSHUA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.KAPOK_SAPLING.get(), (ItemLike)RuBlocks.KAPOK_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.JUNGLE_SAPLING, (ItemLike)RuBlocks.JUNGLE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.LARCH_SAPLING.get(), (ItemLike)RuBlocks.LARCH_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.MANGROVE_PROPAGULE, (ItemLike)RuBlocks.MANGROVE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.MAPLE_SAPLING.get(), (ItemLike)RuBlocks.MAPLE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.MAUVE_SAPLING.get(), (ItemLike)RuBlocks.MAUVE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.OAK_SAPLING, (ItemLike)RuBlocks.OAK_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.ORANGE_MAPLE_SAPLING.get(), (ItemLike)RuBlocks.ORANGE_MAPLE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PALM_SAPLING.get(), (ItemLike)RuBlocks.PALM_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PINE_SAPLING.get(), (ItemLike)RuBlocks.PINE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BLUE_MAGNOLIA_SAPLING.get(), (ItemLike)RuBlocks.BLUE_MAGNOLIA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PINK_MAGNOLIA_SAPLING.get(), (ItemLike)RuBlocks.PINK_MAGNOLIA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.REDWOOD_SAPLING.get(), (ItemLike)RuBlocks.REDWOOD_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.RED_MAPLE_SAPLING.get(), (ItemLike)RuBlocks.RED_MAPLE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.ENCHANTED_BIRCH_SAPLING.get(), (ItemLike)RuBlocks.ENCHANTED_BIRCH_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.SILVER_BIRCH_SAPLING.get(), (ItemLike)RuBlocks.SILVER_BIRCH_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.SOCOTRA_SAPLING.get(), (ItemLike)RuBlocks.SOCOTRA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.SPRUCE_SAPLING, (ItemLike)RuBlocks.SPRUCE_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.WHITE_MAGNOLIA_SAPLING.get(), (ItemLike)RuBlocks.WHITE_MAGNOLIA_SHRUB.get(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.WILLOW_SAPLING.get(), (ItemLike)RuBlocks.WILLOW_SHRUB.get(), "saplings", 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.ASHEN_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.ASHEN_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_ashen_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.ASHEN_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.ACACIA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.ACACIA_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_acacia_sapling", RuRecipeProvider.has((ItemLike)Blocks.ACACIA_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BAOBAB_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BAOBAB_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_baobab_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BAOBAB_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BIRCH_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.BIRCH_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_birch_sapling", RuRecipeProvider.has((ItemLike)Blocks.BIRCH_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BLACKWOOD_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLACKWOOD_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_blackwood_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLACKWOOD_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BRIMWOOD_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BRIMWOOD_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_brimwood_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BRIMWOOD_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.CHERRY_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.CHERRY_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_cherry_sapling", RuRecipeProvider.has((ItemLike)Blocks.CHERRY_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.MAGNOLIA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.MAGNOLIA_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_magnolia_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.MAGNOLIA_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.CYPRESS_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.CYPRESS_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_cypress_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CYPRESS_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.DARK_OAK_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DARK_OAK_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_dark_oak_sapling", RuRecipeProvider.has((ItemLike)Blocks.DARK_OAK_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.DEAD_PINE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.DEAD_PINE_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_dead_pine_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.DEAD_PINE_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.DEAD_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.DEAD_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_dead_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.DEAD_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.EUCALYPTUS_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.EUCALYPTUS_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_eucalyptus_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.EUCALYPTUS_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.FLOWERING_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.FLOWERING_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_flowering_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.FLOWERING_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.GOLDEN_LARCH_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.GOLDEN_LARCH_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_golden_larch_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GOLDEN_LARCH_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.JOSHUA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.JOSHUA_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_joshua_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.JOSHUA_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.KAPOK_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.KAPOK_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_kapok_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.KAPOK_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.JUNGLE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.JUNGLE_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_jungle_sapling", RuRecipeProvider.has((ItemLike)Blocks.JUNGLE_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.LARCH_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.LARCH_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_larch_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.LARCH_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.MANGROVE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.MANGROVE_PROPAGULE).pattern("#").pattern("#").group("shrubs").unlockedBy("has_mangrove_propagule", RuRecipeProvider.has((ItemLike)Blocks.MANGROVE_PROPAGULE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.MAPLE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.MAPLE_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_maple_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.MAPLE_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.MAUVE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.MAUVE_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_mauve_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.MAUVE_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.OAK_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.OAK_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_oak_sapling", RuRecipeProvider.has((ItemLike)Blocks.OAK_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.ORANGE_MAPLE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.ORANGE_MAPLE_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_orange_maple_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.ORANGE_MAPLE_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.PALM_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PALM_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_palm_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PALM_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.PINE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINE_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_pine_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINE_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BLUE_MAGNOLIA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_MAGNOLIA_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_blue_magnolia_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_MAGNOLIA_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.PINK_MAGNOLIA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_MAGNOLIA_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_pink_magnolia_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_MAGNOLIA_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.REDWOOD_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.REDWOOD_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_redwood_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.REDWOOD_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.RED_MAPLE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.RED_MAPLE_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_red_maple_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.RED_MAPLE_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.ENCHANTED_BIRCH_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.ENCHANTED_BIRCH_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_enchanted_birch_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.ENCHANTED_BIRCH_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.SILVER_BIRCH_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.SILVER_BIRCH_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_silver_birch_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.SILVER_BIRCH_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.SOCOTRA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.SOCOTRA_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_socotra_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.SOCOTRA_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.SPRUCE_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.SPRUCE_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_spruce_sapling", RuRecipeProvider.has((ItemLike)Blocks.SPRUCE_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.WHITE_MAGNOLIA_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.WHITE_MAGNOLIA_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_white_magnolia_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.WHITE_MAGNOLIA_SAPLING.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.WILLOW_SHRUB.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.WILLOW_SAPLING.get()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_willow_sapling", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.WILLOW_SAPLING.get()))).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_BLUE_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get(), "blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_GREEN_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIME_DYE, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get(), "lime_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_PINK_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_BIOSHROOM.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get(), "yellow_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_BLUE_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_blue_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_GREEN_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_green_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_PINK_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_pink_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_yellow_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.ICE).define(Character.valueOf('#'), (ItemLike)RuBlocks.ICICLE.get()).pattern("##").pattern("##").group("ice").unlockedBy("has_icicle", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.ICICLE.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)Blocks.ICE, (ItemLike)((ItemLike)RuBlocks.ICICLE.get()))));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BARREL_CACTUS.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, (float)1.0f, (int)200).group("cactus").unlockedBy("has_barrel_cactus", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BARREL_CACTUS.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)Items.GREEN_DYE, (ItemLike)((ItemLike)RuBlocks.BARREL_CACTUS.get()))));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.CAVE_HYSSOP.get(), "orange_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_blue_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_blue_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_green_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_green_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_pink_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_pink_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_BLOCK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_yellow_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_yellow_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()))).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SAGUARO_CACTUS.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, (float)1.0f, (int)200).group("cactus").unlockedBy("has_saguaro_cactus", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.SAGUARO_CACTUS.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)Items.GREEN_DYE, (ItemLike)((ItemLike)RuBlocks.SAGUARO_CACTUS.get()))));
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.ACACIA_BRANCH.get(), (ItemLike)Blocks.ACACIA_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.ACACIA_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.BAOBAB_BRANCH.get(), (ItemLike)RuBlocks.BAOBAB_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.BAOBAB_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.BIRCH_BRANCH.get(), (ItemLike)Blocks.BIRCH_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.BIRCH_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.BLACKWOOD_BRANCH.get(), (ItemLike)RuBlocks.BLACKWOOD_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.BLACKWOOD_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MAGNOLIA_BRANCH.get(), (ItemLike)RuBlocks.MAGNOLIA_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MAGNOLIA_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.CYPRESS_BRANCH.get(), (ItemLike)RuBlocks.CYPRESS_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.CYPRESS_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.CHERRY_BRANCH.get(), (ItemLike)Blocks.CHERRY_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.CHERRY_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.DARK_OAK_BRANCH.get(), (ItemLike)Blocks.DARK_OAK_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.DARK_OAK_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.DEAD_BRANCH.get(), (ItemLike)RuBlocks.DEAD_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.DEAD_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.EUCALYPTUS_BRANCH.get(), (ItemLike)RuBlocks.EUCALYPTUS_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.EUCALYPTUS_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.JOSHUA_BEARD.get(), (ItemLike)RuBlocks.JOSHUA_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.JOSHUA_BEARD.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.KAPOK_BRANCH.get(), (ItemLike)RuBlocks.KAPOK_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.KAPOK_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.JUNGLE_BRANCH.get(), (ItemLike)Blocks.JUNGLE_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.JUNGLE_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.LARCH_BRANCH.get(), (ItemLike)RuBlocks.LARCH_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.LARCH_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MANGROVE_BRANCH.get(), (ItemLike)Blocks.MANGROVE_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MANGROVE_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MAPLE_BRANCH.get(), (ItemLike)RuBlocks.MAPLE_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MAPLE_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MAUVE_BRANCH.get(), (ItemLike)RuBlocks.MAUVE_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MAUVE_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.OAK_BRANCH.get(), (ItemLike)Blocks.OAK_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.OAK_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.PALM_BEARD.get(), (ItemLike)RuBlocks.PALM_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.PALM_BEARD.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.PINE_BRANCH.get(), (ItemLike)RuBlocks.PINE_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.PINE_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.REDWOOD_BRANCH.get(), (ItemLike)RuBlocks.REDWOOD_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.REDWOOD_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.SILVER_BIRCH_BRANCH.get(), (ItemLike)RuBlocks.SILVER_BIRCH_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.SILVER_BIRCH_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.SOCOTRA_BRANCH.get(), (ItemLike)RuBlocks.SOCOTRA_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.SOCOTRA_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.SPRUCE_BRANCH.get(), (ItemLike)Blocks.SPRUCE_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.SPRUCE_BRANCH.get(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.WILLOW_BRANCH.get(), (ItemLike)RuBlocks.WILLOW_LOG.get());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.WILLOW_BRANCH.get(), "stick", 4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PEAT_COARSE_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.PEAT_DIRT.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GRAVEL).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_gravel", RuRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.SILT_COARSE_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.SILT_DIRT.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GRAVEL).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_gravel", RuRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)Blocks.DIRT).define(Character.valueOf('G'), RuTags.ASH_ITEM).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_ash", RuRecipeProvider.has(RuTags.ASH_ITEM)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (ItemLike)Blocks.DIRT)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.PEAT_DIRT.get()).define(Character.valueOf('G'), RuTags.ASH_ITEM).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_ash", RuRecipeProvider.has(RuTags.ASH_ITEM)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (ItemLike)((ItemLike)RuBlocks.PEAT_DIRT.get()))));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.SILT_DIRT.get()).define(Character.valueOf('G'), RuTags.ASH_ITEM).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_ash", RuRecipeProvider.has(RuTags.ASH_ITEM)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (ItemLike)((ItemLike)RuBlocks.SILT_DIRT.get()))));
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK.get()})).group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_SLAB.get(), (ItemLike)RuBlocks.CHALK.get(), 2);
        RuRecipeProvider.stairBuilder((ItemLike)((ItemLike)RuBlocks.CHALK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK.get()})).group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_STAIRS.get(), (ItemLike)RuBlocks.CHALK.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.CHALK.get()).define(Character.valueOf('X'), RuTags.GRASS_ITEM).pattern("X").pattern("#").group("stone_grass").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_BRICKS.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.POLISHED_CHALK.get()).pattern("##").pattern("##").group("chalk").unlockedBy("has_polished_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.CHALK_PILLAR.get());
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_BRICK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK_BRICKS.get()})).group("chalk").unlockedBy("has_chalk_bricks", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK_BRICKS.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICK_SLAB.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get(), 2);
        RuRecipeProvider.stairBuilder((ItemLike)((ItemLike)RuBlocks.CHALK_BRICK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK_BRICKS.get()})).group("chalk").unlockedBy("has_chalk_bricks", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK_BRICKS.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICK_STAIRS.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_PILLAR.get()), (int)2).define(Character.valueOf('#'), (ItemLike)RuBlocks.CHALK.get()).pattern("#").pattern("#").group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.CHALK.get()).pattern("##").pattern("##").group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_PILLAR.get());
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.POLISHED_CHALK.get()})).group("chalk").unlockedBy("has_polished_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK_SLAB.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get(), 2);
        RuRecipeProvider.stairBuilder((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.POLISHED_CHALK.get()})).group("chalk").unlockedBy("has_polished_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK_STAIRS.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.MOSSY_STONE.get()), (int)1).requires((ItemLike)Blocks.STONE).requires((ItemLike)Blocks.VINE).group("mossy").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).unlockedBy("has_vine", RuRecipeProvider.has((ItemLike)Blocks.VINE)).save(consumer);
        RuRecipeProvider.oreSmelting(consumer, (List)MOSSY_STONE_SMELTABLES.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.MOSSY_STONE.get(), 0.1f, 200, "mossy");
        RuRecipeProvider.oreBlasting(consumer, (List)MOSSY_STONE_SMELTABLES.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.MOSSY_STONE.get(), 0.1f, 100, "mossy");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.HYACINTH_LAMP.get())).define(Character.valueOf('#'), (ItemLike)Items.PRISMARINE_SLAB).define(Character.valueOf('X'), RuTags.HYACINTH_BLOOMS_ITEM).pattern("X").pattern("#").group("hyacinth").unlockedBy("has_prismarine_slab", RuRecipeProvider.has((ItemLike)Items.PRISMARINE_SLAB)).unlockedBy("has_hyacinth", RuRecipeProvider.has(RuTags.HYACINTH_BLOOMS_ITEM)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASH.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Items.GUNPOWDER).pattern("##").pattern("##").group("ash").unlockedBy("has_gunpowder", RuRecipeProvider.has((ItemLike)Items.GUNPOWDER)).save(consumer);
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.ASHEN_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.ASHEN_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.SILVER_BIRCH_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.SILVER_BIRCH_LOG.get()));
        RuRecipeProvider.planksFromOneLog(consumer, (ItemLike)RuBlocks.ALPHA_PLANKS.get(), (ItemLike)RuBlocks.ALPHA_LOG.get(), 4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.ALPHA_STAIRS.get(), (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.ALPHA_SLAB.get(), (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)Items.OAK_FENCE, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)Items.OAK_DOOR, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)Items.OAK_FENCE_GATE, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)Items.OAK_TRAPDOOR, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)Items.OAK_PRESSURE_PLATE, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)Items.OAK_BUTTON, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)Items.OAK_SIGN, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)Items.OAK_HANGING_SIGN, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)Items.OAK_BOAT, (ItemLike)RuBlocks.ALPHA_PLANKS.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BAOBAB_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.BAOBAB_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_BAOBAB_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_BAOBAB_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BAOBAB_PLANKS.get()), RuTags.BAOBAB_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.BAOBAB_STAIRS.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.BAOBAB_SLAB.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.BAOBAB_FENCE.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.BAOBAB_DOOR.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.BAOBAB_FENCE_GATE.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.BAOBAB_TRAPDOOR.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.BAOBAB_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.BAOBAB_BUTTON.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.BAOBAB_SIGN.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.BAOBAB_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_BAOBAB_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.BAOBAB_BOAT.get(), (ItemLike)RuBlocks.BAOBAB_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.BAOBAB_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.BAOBAB_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BRIMWOOD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.BRIMWOOD_LOG.get()));
        RuRecipeProvider.woodFromOtherItem(consumer, (ItemLike)RuBlocks.BRIMWOOD_WOOD.get(), (ItemLike)RuBlocks.BRIMWOOD_LOG_MAGMA.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_BRIMWOOD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_BRIMWOOD_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BRIMWOOD_PLANKS.get()), RuTags.BRIMWOOD_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.BRIMWOOD_STAIRS.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.BRIMWOOD_SLAB.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.BRIMWOOD_FENCE.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.BRIMWOOD_DOOR.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.BRIMWOOD_FENCE_GATE.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.BRIMWOOD_TRAPDOOR.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.BRIMWOOD_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.BRIMWOOD_BUTTON.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.BRIMWOOD_SIGN.get(), (ItemLike)RuBlocks.BRIMWOOD_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.BRIMWOOD_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_BRIMWOOD_LOG.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_STEM.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_BLUE_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_BLUE_BIOSHROOM_STEM.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get()), RuTags.BLUE_BIOSHROOM_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_STAIRS.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_SLAB.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_FENCE.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_DOOR.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_FENCE_GATE.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_TRAPDOOR.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_BUTTON.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_SIGN.get(), (ItemLike)RuBlocks.BLUE_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_BLUE_BIOSHROOM_STEM.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BLACKWOOD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.BLACKWOOD_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_BLACKWOOD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_BLACKWOOD_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.BLACKWOOD_PLANKS.get()), RuTags.BLACKWOOD_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.BLACKWOOD_STAIRS.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.BLACKWOOD_SLAB.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.BLACKWOOD_FENCE.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.BLACKWOOD_DOOR.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.BLACKWOOD_FENCE_GATE.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.BLACKWOOD_TRAPDOOR.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.BLACKWOOD_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.BLACKWOOD_BUTTON.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.BLACKWOOD_SIGN.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.BLACKWOOD_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_BLACKWOOD_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.BLACKWOOD_BOAT.get(), (ItemLike)RuBlocks.BLACKWOOD_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.BLACKWOOD_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.BLACKWOOD_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.COBALT_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.COBALT_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_COBALT_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_COBALT_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.COBALT_PLANKS.get()), RuTags.COBALT_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.COBALT_STAIRS.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.COBALT_SLAB.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.COBALT_FENCE.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.COBALT_DOOR.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.COBALT_FENCE_GATE.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.COBALT_TRAPDOOR.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.COBALT_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.COBALT_BUTTON.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.COBALT_SIGN.get(), (ItemLike)RuBlocks.COBALT_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.COBALT_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_COBALT_LOG.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.CYPRESS_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.CYPRESS_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_CYPRESS_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_CYPRESS_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.CYPRESS_PLANKS.get()), RuTags.CYPRESS_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.CYPRESS_STAIRS.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.CYPRESS_SLAB.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.CYPRESS_FENCE.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.CYPRESS_DOOR.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.CYPRESS_FENCE_GATE.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.CYPRESS_TRAPDOOR.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.CYPRESS_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.CYPRESS_BUTTON.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.CYPRESS_SIGN.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.CYPRESS_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_CYPRESS_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.CYPRESS_BOAT.get(), (ItemLike)RuBlocks.CYPRESS_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.CYPRESS_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.CYPRESS_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.DEAD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.DEAD_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_DEAD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_DEAD_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.DEAD_PLANKS.get()), RuTags.DEAD_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.DEAD_STAIRS.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.DEAD_SLAB.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.DEAD_FENCE.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.DEAD_DOOR.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.DEAD_FENCE_GATE.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.DEAD_TRAPDOOR.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.DEAD_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.DEAD_BUTTON.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.DEAD_SIGN.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.DEAD_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_DEAD_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.DEAD_BOAT.get(), (ItemLike)RuBlocks.DEAD_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.DEAD_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.DEAD_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.EUCALYPTUS_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.EUCALYPTUS_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_EUCALYPTUS_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_EUCALYPTUS_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get()), RuTags.EUCALYPTUS_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.EUCALYPTUS_STAIRS.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.EUCALYPTUS_SLAB.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.EUCALYPTUS_FENCE.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.EUCALYPTUS_DOOR.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.EUCALYPTUS_FENCE_GATE.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.EUCALYPTUS_TRAPDOOR.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.EUCALYPTUS_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.EUCALYPTUS_BUTTON.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.EUCALYPTUS_SIGN.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.EUCALYPTUS_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_EUCALYPTUS_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.EUCALYPTUS_BOAT.get(), (ItemLike)RuBlocks.EUCALYPTUS_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.EUCALYPTUS_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.EUCALYPTUS_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_STEM.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_GREEN_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_GREEN_BIOSHROOM_STEM.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get()), RuTags.GREEN_BIOSHROOM_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_STAIRS.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_SLAB.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_FENCE.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_DOOR.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_FENCE_GATE.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_TRAPDOOR.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_BUTTON.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_SIGN.get(), (ItemLike)RuBlocks.GREEN_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_GREEN_BIOSHROOM_STEM.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.JOSHUA_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.JOSHUA_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_JOSHUA_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_JOSHUA_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.JOSHUA_PLANKS.get()), RuTags.JOSHUA_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.JOSHUA_STAIRS.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.JOSHUA_SLAB.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.JOSHUA_FENCE.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.JOSHUA_DOOR.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.JOSHUA_FENCE_GATE.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.JOSHUA_TRAPDOOR.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.JOSHUA_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.JOSHUA_BUTTON.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.JOSHUA_SIGN.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.JOSHUA_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_JOSHUA_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.JOSHUA_BOAT.get(), (ItemLike)RuBlocks.JOSHUA_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.JOSHUA_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.JOSHUA_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.KAPOK_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.KAPOK_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_KAPOK_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_KAPOK_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.KAPOK_PLANKS.get()), RuTags.KAPOK_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.KAPOK_STAIRS.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.KAPOK_SLAB.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.KAPOK_FENCE.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.KAPOK_DOOR.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.KAPOK_FENCE_GATE.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.KAPOK_TRAPDOOR.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.KAPOK_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.KAPOK_BUTTON.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.KAPOK_SIGN.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.KAPOK_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_KAPOK_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.KAPOK_BOAT.get(), (ItemLike)RuBlocks.KAPOK_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.KAPOK_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.KAPOK_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.LARCH_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.LARCH_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_LARCH_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_LARCH_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.LARCH_PLANKS.get()), RuTags.LARCH_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.LARCH_STAIRS.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.LARCH_SLAB.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.LARCH_FENCE.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.LARCH_DOOR.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.LARCH_FENCE_GATE.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.LARCH_TRAPDOOR.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.LARCH_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.LARCH_BUTTON.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.LARCH_SIGN.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.LARCH_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_LARCH_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.LARCH_BOAT.get(), (ItemLike)RuBlocks.LARCH_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.LARCH_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.LARCH_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.MAGNOLIA_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.MAGNOLIA_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_MAGNOLIA_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_MAGNOLIA_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.MAGNOLIA_PLANKS.get()), RuTags.MAGNOLIA_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.MAGNOLIA_STAIRS.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.MAGNOLIA_SLAB.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.MAGNOLIA_FENCE.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.MAGNOLIA_DOOR.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.MAGNOLIA_FENCE_GATE.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.MAGNOLIA_TRAPDOOR.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.MAGNOLIA_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.MAGNOLIA_BUTTON.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.MAGNOLIA_SIGN.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.MAGNOLIA_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_MAGNOLIA_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.MAGNOLIA_BOAT.get(), (ItemLike)RuBlocks.MAGNOLIA_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.MAGNOLIA_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.MAGNOLIA_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.MAPLE_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.MAPLE_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_MAPLE_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_MAPLE_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.MAPLE_PLANKS.get()), RuTags.MAPLE_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.MAPLE_STAIRS.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.MAPLE_SLAB.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.MAPLE_FENCE.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.MAPLE_DOOR.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.MAPLE_FENCE_GATE.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.MAPLE_TRAPDOOR.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.MAPLE_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.MAPLE_BUTTON.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.MAPLE_SIGN.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.MAPLE_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_MAPLE_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.MAPLE_BOAT.get(), (ItemLike)RuBlocks.MAPLE_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.MAPLE_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.MAPLE_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.MAUVE_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.MAUVE_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_MAUVE_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_MAUVE_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.MAUVE_PLANKS.get()), RuTags.MAUVE_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.MAUVE_STAIRS.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.MAUVE_SLAB.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.MAUVE_FENCE.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.MAUVE_DOOR.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.MAUVE_FENCE_GATE.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.MAUVE_TRAPDOOR.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.MAUVE_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.MAUVE_BUTTON.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.MAUVE_SIGN.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.MAUVE_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_MAUVE_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.MAUVE_BOAT.get(), (ItemLike)RuBlocks.MAUVE_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.MAUVE_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.MAUVE_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.PALM_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.PALM_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_PALM_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_PALM_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.PALM_PLANKS.get()), RuTags.PALM_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.PALM_STAIRS.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.PALM_SLAB.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.PALM_FENCE.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.PALM_DOOR.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.PALM_FENCE_GATE.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.PALM_TRAPDOOR.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.PALM_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.PALM_BUTTON.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.PALM_SIGN.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.PALM_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_PALM_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.PALM_BOAT.get(), (ItemLike)RuBlocks.PALM_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.PALM_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.PALM_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.PINE_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.PINE_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_PINE_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_PINE_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.PINE_PLANKS.get()), RuTags.PINE_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.PINE_STAIRS.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.PINE_SLAB.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.PINE_FENCE.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.PINE_DOOR.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.PINE_FENCE_GATE.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.PINE_TRAPDOOR.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.PINE_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.PINE_BUTTON.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.PINE_SIGN.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.PINE_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_PINE_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.PINE_BOAT.get(), (ItemLike)RuBlocks.PINE_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.PINE_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.PINE_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_STEM.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_PINK_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_PINK_BIOSHROOM_STEM.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get()), RuTags.PINK_BIOSHROOM_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_STAIRS.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_SLAB.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_FENCE.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_DOOR.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_FENCE_GATE.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_TRAPDOOR.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_BUTTON.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_SIGN.get(), (ItemLike)RuBlocks.PINK_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_PINK_BIOSHROOM_STEM.get());
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.REDWOOD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.REDWOOD_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_REDWOOD_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_REDWOOD_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.REDWOOD_PLANKS.get()), RuTags.REDWOOD_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.REDWOOD_STAIRS.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.REDWOOD_SLAB.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.REDWOOD_FENCE.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.REDWOOD_DOOR.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.REDWOOD_FENCE_GATE.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.REDWOOD_TRAPDOOR.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.REDWOOD_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.REDWOOD_BUTTON.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.REDWOOD_SIGN.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.REDWOOD_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_REDWOOD_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.REDWOOD_BOAT.get(), (ItemLike)RuBlocks.REDWOOD_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.REDWOOD_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.REDWOOD_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.SOCOTRA_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.SOCOTRA_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_SOCOTRA_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_SOCOTRA_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.SOCOTRA_PLANKS.get()), RuTags.SOCOTRA_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.SOCOTRA_STAIRS.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.SOCOTRA_SLAB.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.SOCOTRA_FENCE.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.SOCOTRA_DOOR.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.SOCOTRA_FENCE_GATE.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.SOCOTRA_TRAPDOOR.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.SOCOTRA_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.SOCOTRA_BUTTON.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.SOCOTRA_SIGN.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.SOCOTRA_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_SOCOTRA_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.SOCOTRA_BOAT.get(), (ItemLike)RuBlocks.SOCOTRA_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.SOCOTRA_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.SOCOTRA_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.WILLOW_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.WILLOW_LOG.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_WILLOW_WOOD.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_WILLOW_LOG.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.WILLOW_PLANKS.get()), RuTags.WILLOW_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.WILLOW_STAIRS.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.WILLOW_SLAB.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.WILLOW_FENCE.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.WILLOW_DOOR.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.WILLOW_FENCE_GATE.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.WILLOW_TRAPDOOR.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.WILLOW_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.WILLOW_BUTTON.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.WILLOW_SIGN.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.WILLOW_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_WILLOW_LOG.get());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)RuItems.WILLOW_BOAT.get(), (ItemLike)RuBlocks.WILLOW_PLANKS.get());
        RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)((ItemLike)RuItems.WILLOW_CHEST_BOAT.get()), (ItemLike)((ItemLike)RuItems.WILLOW_BOAT.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_STEM.get()));
        RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.STRIPPED_YELLOW_BIOSHROOM_HYPHAE.get()), (ItemLike)((ItemLike)RuBlocks.STRIPPED_YELLOW_BIOSHROOM_STEM.get()));
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get()), RuTags.YELLOW_BIOSHROOM_LOGS_ITEM, (int)4);
        RuRecipeProvider.woodenStairs(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_STAIRS.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSlab(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_SLAB.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFence(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_FENCE.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_DOOR.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_FENCE_GATE.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_TRAPDOOR.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PRESSURE_PLATE.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_BUTTON.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_SIGN.get(), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_PLANKS.get());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM_HANGING_SIGN.get(), (ItemLike)RuBlocks.STRIPPED_YELLOW_BIOSHROOM_STEM.get());
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.RED_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.ORANGE_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"orange_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.YELLOW_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"yellow_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.LIME_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"lime_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.GREEN_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"green_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.CYAN_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"cyan_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.LIGHT_BLUE_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"light_blue_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.BLUE_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"blue_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.PURPLE_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"purple_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.MAGENTA_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"magenta_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.PINK_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"pink_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.BROWN_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"brown_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.WHITE_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"white_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.LIGHT_GRAY_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"light_gray_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.GRAY_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gray_dyes")));
        RuRecipeProvider.paintedPlanks(consumer, (ItemLike)RuBlocks.BLACK_PAINTED_PLANKS.get(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"black_dyes")));
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.RED_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.RED_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.ORANGE_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.ORANGE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.YELLOW_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.YELLOW_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.LIME_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.LIME_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.GREEN_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.GREEN_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.CYAN_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.CYAN_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.LIGHT_BLUE_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.LIGHT_BLUE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.BLUE_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.BLUE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.PURPLE_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.PURPLE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.MAGENTA_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.MAGENTA_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.PINK_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.PINK_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.BROWN_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.BROWN_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.WHITE_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.WHITE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.LIGHT_GRAY_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.LIGHT_GRAY_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.GRAY_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.GRAY_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedStairs(consumer, (ItemLike)RuBlocks.BLACK_PAINTED_STAIRS.get(), (ItemLike)RuBlocks.BLACK_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.RED_PAINTED_SLAB.get(), (ItemLike)RuBlocks.RED_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.ORANGE_PAINTED_SLAB.get(), (ItemLike)RuBlocks.ORANGE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.YELLOW_PAINTED_SLAB.get(), (ItemLike)RuBlocks.YELLOW_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.LIME_PAINTED_SLAB.get(), (ItemLike)RuBlocks.LIME_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.GREEN_PAINTED_SLAB.get(), (ItemLike)RuBlocks.GREEN_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.CYAN_PAINTED_SLAB.get(), (ItemLike)RuBlocks.CYAN_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.LIGHT_BLUE_PAINTED_SLAB.get(), (ItemLike)RuBlocks.LIGHT_BLUE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.BLUE_PAINTED_SLAB.get(), (ItemLike)RuBlocks.BLUE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.PURPLE_PAINTED_SLAB.get(), (ItemLike)RuBlocks.PURPLE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.MAGENTA_PAINTED_SLAB.get(), (ItemLike)RuBlocks.MAGENTA_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.PINK_PAINTED_SLAB.get(), (ItemLike)RuBlocks.PINK_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.BROWN_PAINTED_SLAB.get(), (ItemLike)RuBlocks.BROWN_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.WHITE_PAINTED_SLAB.get(), (ItemLike)RuBlocks.WHITE_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.LIGHT_GRAY_PAINTED_SLAB.get(), (ItemLike)RuBlocks.LIGHT_GRAY_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.GRAY_PAINTED_SLAB.get(), (ItemLike)RuBlocks.GRAY_PAINTED_PLANKS.get());
        RuRecipeProvider.paintedSlab(consumer, (ItemLike)RuBlocks.BLACK_PAINTED_SLAB.get(), (ItemLike)RuBlocks.BLACK_PAINTED_PLANKS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()), (int)2).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).pattern("##").pattern("##").group("blackstone").unlockedBy("has_blackstone", RuRecipeProvider.has((ItemLike)Blocks.BLACKSTONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BLACKSTONE, (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()).pattern("##").group("blackstone").unlockedBy("has_blackstone_cluster", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)Blocks.BLACKSTONE, (ItemLike)((ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()))));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()), (int)1).requires((ItemLike)Blocks.BONE_BLOCK).requires((ItemLike)RuBlocks.GLISTERING_NYLIUM.get()).group("overgrown_bone_block").unlockedBy("has_glistering_nylium", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GLISTERING_NYLIUM.get()))).unlockedBy("has_bone_block", RuRecipeProvider.has((ItemLike)Blocks.BONE_BLOCK)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL, (int)9).requires((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()).group("bone_meal").unlockedBy("has_overgrown_bone_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)Items.BONE_MEAL, (ItemLike)((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()))));
    }

    public static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block p_125980_) {
        return CriteriaTriggers.ENTER_BLOCK.createCriterion((CriterionTriggerInstance)new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(p_125980_.builtInRegistryHolder()), Optional.empty()));
    }

    protected static void branchFromLog(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item, (int)2).define(Character.valueOf('#'), item2).define(Character.valueOf('X'), (ItemLike)Items.STICK).pattern("#X").group("branches").unlockedBy("has_log", RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2)));
    }

    protected static void woodFromOtherItem(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)3).define(Character.valueOf('#'), item2).pattern("##").pattern("##").group("bark").unlockedBy("has_log", RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2)));
    }

    protected static void paintedSlab(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("painted_slab").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void paintedStairs(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.stairBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("painted_stairs").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void paintedPlanks(RecipeOutput consumer, ItemLike result, TagKey<Item> dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)8).define(Character.valueOf('X'), dye).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("###").pattern("#X#").pattern("###").group("painted_planks").unlockedBy("has_planks", RuRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(consumer);
    }

    protected static void snowbelle(RecipeOutput consumer, ItemLike result, TagKey<Item> dye) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires(dye).requires(RuTags.SNOWBELLE_ITEM).group("snowbelle").unlockedBy("has_snowbelle", RuRecipeProvider.has(RuTags.SNOWBELLE_ITEM)).save(consumer);
    }

    protected static void planksFromOneLog(RecipeOutput p_259712_, ItemLike p_259052_, ItemLike p_259045_, int i) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)p_259052_, (int)i).requires(p_259045_).group("planks").unlockedBy("has_log", RuRecipeProvider.has((ItemLike)p_259045_)).save(p_259712_);
    }

    protected static void woodenButton(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.buttonBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_button").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenSign(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.signBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_sign").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void hangingSign(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item, (int)6).group("hanging_sign").define(Character.valueOf('#'), item2).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenBoat(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)item).define(Character.valueOf('#'), item2).pattern("# #").pattern("###").group("boat").unlockedBy("in_water", RuRecipeProvider.insideOf(Blocks.WATER)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenDoor(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.doorBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_door").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenFenceGate(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.fenceGateBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_fence_gate").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenFence(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.fenceBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_fence").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenSlab(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_slab").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenStairs(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.stairBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_stairs").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenTrapdoor(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)item, (int)2).define(Character.valueOf('#'), item2).pattern("###").pattern("###").group("wooden_trapdoor").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void pressurePlate(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_pressure_plate").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void stonecutterResultFromBase(RecipeOutput consumer, RecipeCategory category, ItemLike item, ItemLike item2) {
        RuRecipeProvider.stonecutterResultFromBase(consumer, category, item, item2, 1);
    }

    protected static void stonecutterResultFromBase(RecipeOutput consumer, RecipeCategory category, ItemLike item, ItemLike item2, int i) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2}), (RecipeCategory)category, (ItemLike)item, (int)i).unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)(RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2) + "_stonecutting")));
    }

    protected static void oreSmelting(RecipeOutput consumer, List<ItemLike> itemLikes, RecipeCategory category, ItemLike item, float f, int i, String s) {
        RuRecipeProvider.oreCooking(consumer, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, itemLikes, category, item, f, i, s, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput consumer, List<ItemLike> itemLikes, RecipeCategory category, ItemLike item, float f, int i, String s) {
        RuRecipeProvider.oreCooking(consumer, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, itemLikes, category, item, f, i, s, "_from_blasting");
    }

    public static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput consumer, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> itemLikes, RecipeCategory category, ItemLike item, float f, int i, String s, String t) {
        for (ItemLike itemlike : itemLikes) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)category, (ItemLike)item, (float)f, (int)i, serializer, factory).group(s).unlockedBy(RuRecipeProvider.getHasName((ItemLike)itemlike), RuRecipeProvider.has((ItemLike)itemlike)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)(RuRecipeProvider.getItemName((ItemLike)item) + t + "_" + RuRecipeProvider.getItemName((ItemLike)itemlike))));
        }
    }

    protected static void oneToOneConversionRecipe(RecipeOutput consumer, ItemLike item, ItemLike item2, @Nullable String group) {
        RuRecipeProvider.oneToOneConversionRecipe(consumer, item, item2, group, 1);
    }

    protected static void oneToOneConversionRecipe(RecipeOutput consumer, ItemLike item, ItemLike item2, @Nullable String group, int ammount) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)ammount).requires(item2).group(group).unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2)));
    }
}

