/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.cave;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.state.properties.HangingPrismariteShape;
import net.regions_unexplored.world.level.block.state.properties.RuBlockStateProperties;

public class HangingPrismariteBlock
extends Block {
    public static final EnumProperty<HangingPrismariteShape> SHAPE = RuBlockStateProperties.HANGING_PRISMARITE_SHAPE;
    protected static final VoxelShape BOX = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public HangingPrismariteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.TIP)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(getter, pos);
        return BOX.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return this.mayPlaceOn(level.getBlockState(blockpos), (BlockGetter)level, blockpos);
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.isFaceSturdy(getter, pos, Direction.DOWN) || state.is(RuBlocks.HANGING_PRISMARITE.get());
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        HangingPrismariteShape shape = (HangingPrismariteShape)((Object)state.getValue(SHAPE));
        if (level.getBlockState(pos.below()) == RuBlocks.HANGING_PRISMARITE.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.TIP))) {
            shape = HangingPrismariteShape.FRUSTUM;
        } else if (level.getBlockState(pos.below()) == RuBlocks.HANGING_PRISMARITE.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.FRUSTUM))) {
            shape = HangingPrismariteShape.COLUMN;
        } else if (!level.getBlockState(pos.below()).is(RuBlocks.HANGING_PRISMARITE.get())) {
            shape = HangingPrismariteShape.TIP;
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getLevel().getBlockState(context.getClickedPos().below()) == RuBlocks.HANGING_PRISMARITE.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.FRUSTUM)) || context.getLevel().getBlockState(context.getClickedPos().below()) == RuBlocks.HANGING_PRISMARITE.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.COLUMN))) {
            return (BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.COLUMN));
        }
        if (context.getLevel().getBlockState(context.getClickedPos().below()) == RuBlocks.HANGING_PRISMARITE.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.TIP))) {
            return (BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.FRUSTUM));
        }
        return (BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)HangingPrismariteShape.TIP));
    }
}

