/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class MeadowRockFeature
extends Feature<NoneFeatureConfiguration> {
    public MeadowRockFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = 5;
        int height_1 = randomSource.nextInt(3);
        int height_2 = randomSource.nextInt(3);
        int height_3 = randomSource.nextInt(3);
        int height_4 = randomSource.nextInt(3);
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            if (placeCheck == 0) {
                this.placeBottom((LevelAccessor)level, (BlockPos)placePos, randomSource);
                this.placeBottom((LevelAccessor)level, placePos.north(), randomSource);
                this.placeBottom((LevelAccessor)level, placePos.north().east(), randomSource);
                this.placeBottom((LevelAccessor)level, placePos.east(), randomSource);
            }
            if (placeCheck <= height_1) {
                this.placeRandomBlock((LevelAccessor)level, (BlockPos)placePos, randomSource);
                if (placeCheck == height_1) {
                    this.placeMoss((LevelAccessor)level, placePos.above(), randomSource);
                }
            }
            if (placeCheck <= height_2) {
                this.placeRandomBlock((LevelAccessor)level, placePos.north(), randomSource);
                if (placeCheck == height_2) {
                    this.placeMoss((LevelAccessor)level, placePos.above().north(), randomSource);
                }
            }
            if (placeCheck <= height_3) {
                this.placeRandomBlock((LevelAccessor)level, placePos.north().east(), randomSource);
                if (placeCheck == height_3) {
                    this.placeMoss((LevelAccessor)level, placePos.above().north().east(), randomSource);
                }
            }
            if (placeCheck <= height_4) {
                this.placeRandomBlock((LevelAccessor)level, placePos.east(), randomSource);
                if (placeCheck == height_4) {
                    this.placeMoss((LevelAccessor)level, placePos.above().east(), randomSource);
                }
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public boolean placeBottom(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Random random = new Random();
        int rd = 2;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; i <= rd; ++i) {
            if (level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.LOGS)) {
                level.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
            }
            this.placeRandomBlock(level, (BlockPos)placePos, randomSource);
            placePos.move(Direction.DOWN);
        }
        return true;
    }

    public boolean placeRandomBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        boolean isBase = false;
        if (level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            isBase = true;
        }
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (MeadowRockFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (randomSource.nextInt(2) == 0) {
                level.setBlock(pos, Blocks.STONE.defaultBlockState(), 2);
            } else {
                level.setBlock(pos, RuBlocks.MOSSY_STONE.get().defaultBlockState(), 2);
            }
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public boolean placeMoss(LevelAccessor level, BlockPos pos, RandomSource randomSource) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced() && level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP) && randomSource.nextInt(4) == 0) {
            level.setBlock(pos, Blocks.MOSS_CARPET.defaultBlockState(), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return MeadowRockFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, MeadowRockFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, MeadowRockFeature::isReplaceableBlock);
    }
}

