/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.container.CryoStasisContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CryoStasisBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    List<BeeEntry> cryoBees = new ArrayList<BeeEntry>();
    public static int SLOT_INPUT = 0;
    public static int SLOT_CAGE = 1;
    public static int SLOT_OUT = 2;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 3, (BlockEntity)this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < SLOT_OUT && stack.getItem().asItem() instanceof BeeCage && (slot != SLOT_INPUT || BeeCage.isFilled(stack));
        }

        public boolean isContainerItem(Item item) {
            return item instanceof BeeCage;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_INPUT;
        }
    };

    public CryoStasisBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CRYO_STASIS.get(), pos, state);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        ListTag listNBT = new ListTag();
        this.cryoBees.forEach(beeEntry -> listNBT.add((Object)beeEntry.serializeNBT(provider)));
        tag.put("BeeList", (Tag)listNBT);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("BeeList")) {
            ListTag listNBT = tag.getList("BeeList", 10);
            listNBT.forEach(beeTag -> this.cryoBees.add(BeeEntry.fromNbt((CompoundTag)beeTag)));
        }
    }

    public static <E extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, CryoStasisBlockEntity blockEntity) {
        Bee entity;
        ItemStack input = blockEntity.inventoryHandler.getStackInSlot(SLOT_INPUT);
        if (!input.isEmpty() && BeeCage.isFilled(input) && (entity = BeeCage.getEntityFromStack(input, level, true)) != null) {
            if (entity instanceof ProductiveBee) {
                ProductiveBee pBee = (ProductiveBee)entity;
            } else {
                blockEntity.cryoBees.add(new BeeEntry(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), false, 1200, 0, 0, 0, 0, 0));
            }
        }
    }

    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.CRYO_STASIS.get()).getDescriptionId());
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public AbstractContainerMenu createMenu(int index, Inventory inventory, Player player) {
        return new CryoStasisContainer(index, inventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    static final class BeeEntry
    implements INBTSerializable<CompoundTag> {
        private final ResourceLocation id;
        private final Boolean isProductive;
        private final Integer cooldown;
        private final Integer productivity;
        private final Integer weatherTolerance;
        private final Integer behavior;
        private final Integer endurance;
        private final Integer temper;

        BeeEntry(ResourceLocation id, boolean isProductive, Integer cooldown, Integer productivity, Integer weatherTolerance, Integer behavior, Integer endurance, Integer temper) {
            this.id = id;
            this.isProductive = isProductive;
            this.cooldown = cooldown;
            this.productivity = productivity;
            this.weatherTolerance = weatherTolerance;
            this.behavior = behavior;
            this.endurance = endurance;
            this.temper = temper;
        }

        public static BeeEntry fromNbt(CompoundTag tag) {
            return new BeeEntry(ResourceLocation.parse((String)tag.getString("id")), tag.getBoolean("isProductive"), tag.getInt("cooldown"), tag.getInt("productivity"), tag.getInt("weatherTolerance"), tag.getInt("behavior"), tag.getInt("endurance"), tag.getInt("temper"));
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putString("id", this.id.toString());
            tag.putBoolean("isProductive", this.isProductive.booleanValue());
            tag.putInt("cooldown", this.cooldown.intValue());
            tag.putInt("productivity", this.productivity.intValue());
            tag.putInt("weatherTolerance", this.weatherTolerance.intValue());
            tag.putInt("behavior", this.behavior.intValue());
            tag.putInt("endurance", this.endurance.intValue());
            tag.putInt("temper", this.temper.intValue());
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Integer cooldown() {
            return this.cooldown;
        }

        public Integer productivity() {
            return this.productivity;
        }

        public Integer weatherTolerance() {
            return this.weatherTolerance;
        }

        public Integer behavior() {
            return this.behavior;
        }

        public Integer endurance() {
            return this.endurance;
        }

        public Integer temper() {
            return this.temper;
        }
    }
}

