/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.container.FeederContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class FeederBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    public Block baseBlock;
    private int tickCounter = 0;
    public IItemHandlerModifiable inventoryHandler;

    public FeederBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.FEEDER.get(), pos, state);
        this.refreshInventoryHandler();
    }

    public boolean isDouble() {
        return this.getBlockState().getValue((Property)BlockStateProperties.SLAB_TYPE) == SlabType.DOUBLE;
    }

    public Block getRandomBlockFromInventory(TagKey<Block> tag, RandomSource random) {
        ArrayList<Block> possibleBlocks = new ArrayList<Block>();
        for (ItemStack stack : this.getInventoryItems()) {
            Item item = stack.getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block itemBlock = blockItem.getBlock();
            if (tag != null && !itemBlock.builtInRegistryHolder().is(tag)) continue;
            possibleBlocks.add(itemBlock);
        }
        return possibleBlocks.size() > 0 ? (Block)possibleBlocks.get(random.nextInt(possibleBlocks.size())) : Blocks.AIR;
    }

    public ItemStack getSpecificItemFromInventory(Item item, RandomSource random) {
        ArrayList<ItemStack> possibleItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getInventoryItems()) {
            if (!stack.is(item)) continue;
            possibleItems.add(stack);
        }
        return possibleItems.size() > 0 ? (ItemStack)possibleItems.get(random.nextInt(possibleItems.size())) : ItemStack.EMPTY;
    }

    public List<ItemStack> getInventoryItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int slot = 0; slot < this.inventoryHandler.getSlots(); ++slot) {
            if (this.inventoryHandler.getStackInSlot(slot).isEmpty()) continue;
            items.add(this.inventoryHandler.getStackInSlot(slot));
        }
        return items;
    }

    @Nonnull
    public Component getName() {
        if (this.isDouble()) {
            return Component.translatable((String)(((Block)ModBlocks.FEEDER.get()).getDescriptionId() + "_double"));
        }
        return Component.translatable((String)((Block)ModBlocks.FEEDER.get()).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new FeederContainer(windowId, playerInventory, this);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level instanceof ServerLevel && blockEntity instanceof FeederBlockEntity && ++((FeederBlockEntity)blockEntity).tickCounter % 164 == 0 && ((Boolean)state.getValue((Property)Feeder.HONEYLOGGED)).booleanValue()) {
            List entities = level.getEntitiesOfClass(Bee.class, new AABB(pos));
            for (Bee entity : entities) {
                if (entity == null) continue;
                entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 80, 0, false, true));
            }
        }
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.baseBlock != null) {
            tag.putString("baseBlock", BuiltInRegistries.BLOCK.getKey((Object)this.baseBlock).toString());
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("baseBlock")) {
            this.baseBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)tag.getString("baseBlock")));
        }
    }

    public void refreshInventoryHandler() {
        this.inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this.isDouble() ? 6 : 3, (BlockEntity)this){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
                return true;
            }

            public boolean isInputSlot(int slot) {
                return true;
            }

            public boolean isInputSlotItem(int slot, ItemStack item) {
                return true;
            }

            public int[] getOutputSlots() {
                if (FeederBlockEntity.this.isDouble()) {
                    return new int[]{0, 1, 2, 3, 4, 5};
                }
                return new int[]{0, 1, 2};
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                FeederBlockEntity.this.setChanged();
            }
        };
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }
}

