/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.CryoStasis;
import cy.jdkdigital.productivebees.common.block.entity.CryoStasisBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CryoStasisContainer
extends AbstractContainer {
    public final CryoStasisBlockEntity blockEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public CryoStasisContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CryoStasisContainer.getTileEntity(playerInventory, data));
    }

    public CryoStasisContainer(int windowId, Inventory playerInventory, CryoStasisBlockEntity blockEntity) {
        this((MenuType)ModContainerTypes.CRYO_STASIS.get(), windowId, playerInventory, blockEntity);
    }

    public CryoStasisContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, CryoStasisBlockEntity blockEntity) {
        super(type, windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, CryoStasisBlockEntity.SLOT_INPUT, 108, 18));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, CryoStasisBlockEntity.SLOT_CAGE, 108, 36));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, CryoStasisBlockEntity.SLOT_OUT, 108, 54));
        this.layoutPlayerInventorySlots(playerInventory, 0, 108, 84);
    }

    private static CryoStasisBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof CryoStasisBlockEntity) {
            return (CryoStasisBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof CryoStasis && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

