/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class ModTags {
    public static Map<ResourceLocation, TagKey<Block>> blockTagCache = new HashMap<ResourceLocation, TagKey<Block>>();
    public static Map<ResourceLocation, TagKey<Item>> itemTagCache = new HashMap<ResourceLocation, TagKey<Item>>();
    public static Map<ResourceLocation, TagKey<Fluid>> fluidTagCache = new HashMap<ResourceLocation, TagKey<Fluid>>();
    public static Map<ResourceLocation, TagKey<EntityType<?>>> entityTagCache = new HashMap();
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS = ModTags.getBlockTag("solitary_overworld_nests");
    public static final TagKey<Block> REED_NESTS = ModTags.getBlockTag("nests/reed_nests");
    public static final TagKey<Block> COLD_NESTS = ModTags.getBlockTag("nests/cold_nests");
    public static final TagKey<Block> WOOD_NESTS = ModTags.getBlockTag("nests/wood_nests");
    public static final TagKey<Block> BUMBLE_BEE_NESTS = ModTags.getBlockTag("nests/bumble_bee");
    public static final TagKey<Block> FOREST_FLOWERS = ModTags.getBlockTag("flowers/forest");
    public static final TagKey<Block> ARID_FLOWERS = ModTags.getBlockTag("flowers/arid");
    public static final TagKey<Block> SWAMP_FLOWERS = ModTags.getBlockTag("flowers/swamp");
    public static final TagKey<Block> SNOW_FLOWERS = ModTags.getBlockTag("flowers/snow");
    public static final TagKey<Block> RIVER_FLOWERS = ModTags.getBlockTag("flowers/river");
    public static final TagKey<Block> QUARRY = ModTags.getBlockTag("flowers/quarry");
    public static final TagKey<Block> LUMBER = ModTags.getBlockTag("flowers/lumber");
    public static final TagKey<Block> DUPE_BLACKLIST = ModTags.getBlockTag("dupe_blacklist");
    public static final TagKey<Block> POWDERY = ModTags.getBlockTag("flowers/powdery");
    public static final TagKey<Block> HIVES_BLOCK = ModTags.getBlockTag("advanced_beehives");
    public static final TagKey<Block> DEFAULT_FLOWERING_BLOCK = ModTags.getBlockTag("default_flowering");
    public static final TagKey<Block> BOXES_BLOCK = ModTags.getBlockTag("expansion_boxes");
    public static final TagKey<Block> CANVAS_HIVES_BLOCK = ModTags.getBlockTag("canvas_beehives");
    public static final TagKey<Block> CANVAS_BOXES_BLOCK = ModTags.getBlockTag("canvas_expansion_boxes");
    public static final TagKey<Block> NOT_FLOWERS = ModTags.getBlockTag("not_flowers_for_spawning_nests");
    public static final TagKey<EntityType<?>> RANCHABLES = ModTags.getEntityTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"ranchables"));
    public static final TagKey<EntityType<?>> EXTERNAL_CAN_POLLINATE = ModTags.getEntityTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"external_can_pollinate"));
    public static final TagKey<EntityType<?>> BEE_ENCASE_BLACKLIST = ModTags.getEntityTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_encase_blacklist"));
    public static final TagKey<EntityType<?>> MAGMA_CUBES = ModTags.getEntityTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"magma_cubes"));
    public static final TagKey<Fluid> HONEY = FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"honey"));
    public static final TagKey<Item> CANVAS_HIVES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"canvas_beehives"));
    public static final TagKey<Item> CANVAS_BOXES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"canvas_expansion_boxes"));
    public static final TagKey<Item> HIVES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"advanced_beehives"));
    public static final TagKey<Item> BOXES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"expansion_boxes"));
    public static final TagKey<Item> WANNABEE_LOOT_BLACKLIST = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"wannabee_loot_blacklist"));
    public static final TagKey<Item> DEFAULT_FLOWERING = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"default_flowering"));
    public static final TagKey<Item> DEFAULT_BREEDING = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"default_breeding_items"));
    public static final TagKey<Item> BEE_TEMPT_ITEMS = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_tempt_items"));
    public static final TagKey<Biome> BEEBEE_SPAWN_BIOMES = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"beebee_spawn_biomes"));

    public static TagKey<Block> getBlockTag(String name) {
        return ModTags.getBlockTag(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)name));
    }

    public static TagKey<Block> getBlockTag(ResourceLocation resourceLocation) {
        if (!blockTagCache.containsKey(resourceLocation)) {
            blockTagCache.put(resourceLocation, (TagKey<Block>)BlockTags.create((ResourceLocation)resourceLocation));
        }
        return blockTagCache.get(resourceLocation);
    }

    public static TagKey<Item> getItemTag(ResourceLocation resourceLocation) {
        if (!itemTagCache.containsKey(resourceLocation)) {
            itemTagCache.put(resourceLocation, (TagKey<Item>)ItemTags.create((ResourceLocation)resourceLocation));
        }
        return itemTagCache.get(resourceLocation);
    }

    public static TagKey<Fluid> getFluidTag(ResourceLocation resourceLocation) {
        if (!fluidTagCache.containsKey(resourceLocation)) {
            fluidTagCache.put(resourceLocation, (TagKey<Fluid>)FluidTags.create((ResourceLocation)resourceLocation));
        }
        return fluidTagCache.get(resourceLocation);
    }

    public static TagKey<EntityType<?>> getEntityTag(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)name);
    }

    public static TagKey<Biome> getBiomeTag(ResourceLocation name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)name);
    }

    public static class Common {
        public static final TagKey<Item> STORAGE_BLOCK_HONEYCOMBS = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"storage_blocks/honeycombs"));
        public static final TagKey<Item> HONEYCOMBS = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"honeycombs"));
        public static final TagKey<Item> HONEY_BUCKETS = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"buckets/honey"));
        public static final TagKey<Item> FISHING_RODS = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/fishing"));
        public static final TagKey<Item> WAXES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"waxes"));
        public static final TagKey<Item> WITHER_SKULL_FRAGMENTS = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"fragments/wither_skull"));
        public static final TagKey<Item> SILICON = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"silicon"));
        public static final TagKey<Item> SOURCE_GEM = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gems/source"));
        public static final TagKey<Item> CAMPFIRES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"campfires"));
        public static final TagKey<Item> HIVES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"hives"));
        public static final TagKey<Item> DYES = ModTags.getItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes"));
    }
}

