/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicaldryingbasin;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;

public class MechanicalDryingBasinRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<IInventoryFluid, RecipeMechanicalDryingBasin, MechanicalDryingBasinRecipeJEI> {
    private final List<ItemStack> inputItem;
    private final Optional<FluidStack> inputFluid;
    private final ItemStack outputItem;
    private final Optional<FluidStack> outputFluid;
    private final int duration;

    public MechanicalDryingBasinRecipeJEI(RecipeMechanicalDryingBasin recipe) {
        super((RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get(), (Recipe)recipe);
        this.inputItem = recipe.getInputIngredient().map(i -> Arrays.stream(i.getItems()).collect(Collectors.toList())).orElseGet(Lists::newArrayList);
        this.inputFluid = recipe.getInputFluid();
        this.outputItem = recipe.getOutputItemFirst();
        this.outputFluid = recipe.getOutputFluid();
        this.duration = recipe.getDuration();
    }

    protected MechanicalDryingBasinRecipeJEI() {
        super((RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get(), null);
        this.inputItem = null;
        this.inputFluid = null;
        this.outputItem = null;
        this.outputFluid = null;
        this.duration = 0;
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public Optional<FluidStack> getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public Optional<FluidStack> getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    protected RecipeType<RecipeMechanicalDryingBasin> getRecipeType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get();
    }

    protected MechanicalDryingBasinRecipeJEI newInstance(RecipeHolder<RecipeMechanicalDryingBasin> recipe) {
        return new MechanicalDryingBasinRecipeJEI((RecipeMechanicalDryingBasin)recipe.value());
    }

    public static List<MechanicalDryingBasinRecipeJEI> getAllRecipes() {
        return Lists.newArrayList(new MechanicalDryingBasinRecipeJEI().createAllRecipes().iterator());
    }
}

