/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.collect.Lists;
import java.util.List;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.FilterableRecipe;
import net.mehvahdjukaar.sawmill.RecipeSorter;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SawmillMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex;
    private final Level level;
    public final Container container;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private List<FilterableRecipe> recipes;
    private ItemStack input;
    private long lastSoundTime;
    private final ResultContainer resultContainer;
    private Runnable slotUpdateListener;
    private FilterableRecipe lastSelectedRecipe = null;
    public boolean isWide = CommonConfigs.WIDE_GUI.get();

    public SawmillMenu(int i, Inventory inventory, FriendlyByteBuf buf) {
        this(i, inventory, ContainerLevelAccess.NULL);
    }

    public SawmillMenu(int i, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super(SawmillMod.SAWMILL_MENU.get(), i);
        int j;
        this.selectedRecipeIndex = DataSlot.standalone();
        this.recipes = Lists.newArrayList();
        this.input = ItemStack.EMPTY;
        this.slotUpdateListener = () -> {};
        this.container = new SimpleContainer(1){

            public void setChanged() {
                super.setChanged();
                SawmillMenu.this.slotsChanged((Container)this);
                SawmillMenu.this.slotUpdateListener.run();
            }
        };
        this.resultContainer = new ResultContainer();
        this.access = containerLevelAccess;
        this.level = inventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, this.isWide ? 17 : 21, 33));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 1, this.isWide ? 146 : 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                stack.onCraftedBy(player.level(), player, stack.getCount());
                SawmillMenu.this.resultContainer.awardUsedRecipes(player, this.getRelevantItems());
                ItemStack itemStack = SawmillMenu.this.inputSlot.remove(((WoodcuttingRecipe)SawmillMenu.this.recipes.get(SawmillMenu.this.selectedRecipeIndex.get()).recipe().value()).getInputCount());
                if (!itemStack.isEmpty()) {
                    SawmillMenu.this.setupResultSlot();
                }
                containerLevelAccess.execute((level, blockPos) -> {
                    long l = level.getGameTime();
                    if (SawmillMenu.this.lastSoundTime != l) {
                        level.playSound(null, blockPos, SawmillMod.SAWMILL_TAKE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        SawmillMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(SawmillMenu.this.inputSlot.getItem());
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<FilterableRecipe> getRecipes() {
        return this.recipes;
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipes.isEmpty();
    }

    public boolean stillValid(Player player) {
        return SawmillMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)SawmillMod.SAWMILL_BLOCK.get());
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id = Byte.toUnsignedInt((byte)id)) || id == 255) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    public void slotsChanged(Container container) {
        ItemStack itemStack = this.inputSlot.getItem();
        ItemStack old = this.input;
        boolean sameStack = itemStack.is(old.getItem());
        int maxItemsThatCanBeConsumed = 5;
        if (!sameStack || itemStack.getCount() < maxItemsThatCanBeConsumed || old.getCount() < maxItemsThatCanBeConsumed) {
            this.input = itemStack.copy();
            this.setupRecipeList(container, itemStack);
        }
    }

    private static SingleRecipeInput createRecipeInput(Container container) {
        return new SingleRecipeInput(container.getItem(0));
    }

    private void setupRecipeList(Container container, ItemStack stack) {
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        if (!stack.isEmpty()) {
            int newInd;
            List matching = this.level.getRecipeManager().getRecipesFor(SawmillMod.WOODCUTTING_RECIPE.get(), (RecipeInput)SawmillMenu.createRecipeInput(container), this.level);
            matching.removeIf(r -> ((WoodcuttingRecipe)r.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).is(SawmillMod.BLACKLIST));
            RecipeSorter.sort(matching, this.level);
            this.recipes = matching.stream().map(FilterableRecipe::of).toList();
            this.recipes = this.recipes.subList(0, Math.min(this.recipes.size(), 255));
            if (this.lastSelectedRecipe != null && (newInd = this.recipes.indexOf(this.lastSelectedRecipe)) != -1) {
                this.selectedRecipeIndex.set(newInd);
            }
        }
        this.lastSelectedRecipe = null;
    }

    void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            FilterableRecipe selected;
            this.lastSelectedRecipe = selected = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack itemStack = ((WoodcuttingRecipe)selected.recipe().value()).assemble(SawmillMenu.createRecipeInput(this.container), (HolderLookup.Provider)this.level.registryAccess());
            if (itemStack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(selected.recipe());
                this.resultSlot.set(itemStack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public MenuType<?> getType() {
        return SawmillMod.SAWMILL_MENU.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            Item item = itemStack2.getItem();
            itemStack = itemStack2.copy();
            if (index == 1) {
                item.onCraftedBy(itemStack2, player.level(), player);
                if (!this.moveItemStackTo(itemStack2, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index == 0 ? !this.moveItemStackTo(itemStack2, 2, 38, false) : (this.level.getRecipeManager().getRecipeFor(SawmillMod.WOODCUTTING_RECIPE.get(), (RecipeInput)new SingleRecipeInput(itemStack2), this.level).isPresent() ? !this.moveItemStackTo(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.moveItemStackTo(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.moveItemStackTo(itemStack2, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
            this.broadcastChanges();
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((level, blockPos) -> this.clearContainer(player, this.container));
    }
}

