/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.advancedfilter;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.amount.ActionButton;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedFilterContainerMenu;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedTag;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedTagSlot;
import com.ultramega.cabletiers.common.mixin.InvokerActionButton;
import com.ultramega.cabletiers.common.packet.c2s.SetAdvancedFilterPacket;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class AdvancedFilterScreen
extends AbstractBaseScreen<AdvancedFilterContainerMenu> {
    static final int ROW_HEIGHT = 18;
    static final int ADVANCED_TAG_HEIGHT = 36;
    static final int RESOURCES_PER_ROW = 9;
    private static final ResourceLocation TEXTURE = CableTiersIdentifierUtil.createCableTiersIdentifier("textures/gui/advanced_filter.png");
    private static final MutableComponent DONE = CableTiersIdentifierUtil.createCableTiersTranslation("gui", "advanced_filter.done");
    private static final WidgetSprites EXPAND_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier((String)"widget/expand"), IdentifierUtil.createIdentifier((String)"widget/expand_disabled"), IdentifierUtil.createIdentifier((String)"widget/expand_focused"), IdentifierUtil.createIdentifier((String)"widget/expand_disabled"));
    private static final WidgetSprites COLLAPSE_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier((String)"widget/collapse"), IdentifierUtil.createIdentifier((String)"widget/collapse_focused"));
    private static final MutableComponent EXPAND = IdentifierUtil.createTranslation((String)"gui", (String)"pattern_grid.alternatives.expand");
    private static final Component SEARCH_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"pattern_grid.alternatives.search_help").withStyle(ChatFormatting.GRAY);
    private static final int TAGS_DISPLAYED = 2;
    private static final int ROWS_PER_TAG = 2;
    private static final int INSET_WIDTH = 194;
    private static final int INSET_HEIGHT = 90;
    private static final int ACTION_BUTTON_HEIGHT = 20;
    private static final int ACTION_BUTTON_SPACING = 20;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private EditBox searchField;
    @Nullable
    private final Screen parent;
    private final int slotIndex;
    @Nullable
    private final TagKey<?> selectedTagKey;
    private final List<CheckboxWidget> advancedTagCheckboxes = new ArrayList<CheckboxWidget>();
    private final List<Button> expandButtons = new ArrayList<Button>();

    public AdvancedFilterScreen(@Nullable Screen parent, Inventory playerInventory, int slotIndex, @Nullable TagKey<?> selectedTagKey, @Nullable PlatformResourceKey selectedResource, Component title) {
        super((AbstractContainerMenu)new AdvancedFilterContainerMenu(selectedResource), playerInventory, title);
        this.slotIndex = slotIndex;
        this.parent = parent;
        this.selectedTagKey = selectedTagKey;
        this.imageWidth = 223;
        this.imageHeight = 182;
    }

    protected void init() {
        super.init();
        this.advancedTagCheckboxes.clear();
        this.expandButtons.clear();
        int x = this.getCheckboxStartX();
        for (int i = 0; i < ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().size(); ++i) {
            this.addWidgetsForTags(i, x);
        }
        this.addConfirmButton(160, 155);
        this.scrollbar = new ScrollbarWidget(this.leftPos + 203, this.topPos + 59, ScrollbarWidget.Type.NORMAL, 90);
        int overflowingRows = ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().size() - 2;
        int maxOffset = this.scrollbar.isSmoothScrolling() ? overflowingRows * 36 : overflowingRows * 2;
        this.scrollbar.setMaxOffset((double)maxOffset);
        this.scrollbar.setEnabled(maxOffset > 0);
        this.scrollbar.setListener(value -> this.updateWidgets());
        this.addWidget((GuiEventListener)this.scrollbar);
        Objects.requireNonNull(this.font);
        this.searchField = new EditBox(this.font, this.leftPos + 24, this.topPos + 46, 187, 9, (Component)Component.empty());
        this.searchField.setBordered(false);
        this.searchField.setVisible(true);
        this.searchField.setCanLoseFocus(true);
        this.searchField.setFocused(false);
        this.searchField.setResponder(query -> ((AdvancedFilterContainerMenu)this.getMenu()).filter((String)query));
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.addRenderableWidget((GuiEventListener)new SearchIconWidget(this.leftPos + 7, this.topPos + 44, () -> SEARCH_HELP, this.searchField));
    }

    private int getCheckboxStartX() {
        return this.leftPos + 8;
    }

    private int getCheckboxStartY() {
        return this.topPos + 59;
    }

    private int getAdvancedTagY(int idx) {
        return this.getCheckboxStartY() + 36 * idx;
    }

    private void addWidgetsForTags(int idx, int x) {
        AdvancedTag advancedTag = ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().get(idx);
        int y = this.getAdvancedTagY(idx);
        boolean hasTranslation = I18n.exists((String)advancedTag.getTranslationKey());
        MutableComponent id = Component.literal((String)advancedTag.getId().toString());
        CheckboxWidget advancedTagCheckbox = new CheckboxWidget(x + 2, y + 9 - 4, 141, (Component)(hasTranslation ? Component.translatable((String)advancedTag.getTranslationKey()) : id), this.font, this.selectedTagKey != null && this.selectedTagKey.location().equals((Object)advancedTag.getId()), CheckboxWidget.Size.SMALL);
        advancedTagCheckbox.setOnPressed((checkbox, selected) -> {
            this.advancedTagCheckboxes.forEach(c -> c.setSelected(false));
            checkbox.setSelected(selected);
        });
        if (hasTranslation) {
            advancedTagCheckbox.setTooltip(Tooltip.create((Component)id));
        }
        this.advancedTagCheckboxes.add((CheckboxWidget)this.addWidget((GuiEventListener)advancedTagCheckbox));
        CustomButton expandButton = new CustomButton(x + 194 - 16 - 1, y + 1, 16, 16, EXPAND_SPRITES, btn -> {
            boolean expanding = advancedTag.expandOrCollapse();
            btn.setSprites(expanding ? COLLAPSE_SPRITES : EXPAND_SPRITES);
        }, (Component)EXPAND);
        expandButton.active = advancedTag.getResources().size() > 9;
        this.expandButtons.add((Button)this.addWidget((GuiEventListener)expandButton));
    }

    protected void containerTick() {
        super.containerTick();
        ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().forEach(AdvancedTag::update);
        this.updateWidgets();
    }

    protected void renderResourceSlots(GuiGraphics graphics) {
        ResourceSlotRendering.render((GuiGraphics)graphics, (ResourceSlot)((AdvancedFilterContainerMenu)this.getMenu()).getFilterSlot(), (int)this.leftPos, (int)this.topPos);
    }

    private void updateWidgets() {
        ScrollbarWidget theScrollbar = this.scrollbar;
        if (theScrollbar == null) {
            return;
        }
        double totalHeight = 0.0;
        int totalRows = 0;
        int scrollbarOffset = (int)theScrollbar.getOffset();
        int y = this.getAdvancedTagY(0) - (theScrollbar.isSmoothScrolling() ? scrollbarOffset : scrollbarOffset * 18);
        for (int i = 0; i < ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().size(); ++i) {
            AdvancedTag advancedTag = ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().get(i);
            CheckboxWidget advancedTagCheckbox = this.advancedTagCheckboxes.get(i);
            Button expandButton = this.expandButtons.get(i);
            if (!advancedTag.isVisible()) {
                advancedTagCheckbox.visible = false;
                expandButton.visible = false;
                this.updateAdvancedTagSlots(advancedTag.getMainSlots(), y, 0, false);
                this.updateAdvancedTagSlots(advancedTag.getOverflowSlots(), y, 1, false);
                continue;
            }
            totalRows += 2;
            int overflowRows = AdvancedFilterScreen.getOverflowRows(advancedTag);
            totalRows += (int)((double)overflowRows * advancedTag.getExpandPct());
            int height = 36 + (int)((double)(overflowRows * 18) * advancedTag.getExpandPct());
            this.updateAdvancedTagCheckbox(advancedTagCheckbox, y);
            this.updateExpandButton(expandButton, y);
            this.updateAdvancedTagSlots(advancedTag.getMainSlots(), y, 0, true);
            this.updateAdvancedTagSlots(advancedTag.getOverflowSlots(), y, 1, advancedTag.getExpandPct() > 0.0);
            totalHeight += (double)height;
            y += height;
        }
        double maxOffset = theScrollbar.isSmoothScrolling() ? totalHeight - 72.0 : (double)(totalRows - 1 - 4);
        theScrollbar.setMaxOffset(maxOffset);
        theScrollbar.setEnabled(maxOffset > 0.0);
    }

    private void updateAdvancedTagCheckbox(CheckboxWidget advancedTagCheckbox, int y) {
        advancedTagCheckbox.setY(y + 9 - 4);
        advancedTagCheckbox.visible = advancedTagCheckbox.getY() >= this.getCheckboxStartY() - advancedTagCheckbox.getHeight() && advancedTagCheckbox.getY() < this.getCheckboxStartY() + 90;
    }

    private void updateExpandButton(Button expandButton, int y) {
        expandButton.setY(y + 1);
        expandButton.visible = expandButton.getY() >= this.getCheckboxStartY() - expandButton.getHeight() && expandButton.getY() < this.getCheckboxStartY() + 90;
    }

    private void updateAdvancedTagSlots(List<AdvancedTagSlot> slots, int y, int rowOffset, boolean visible) {
        for (int i = 0; i < slots.size(); ++i) {
            int row = i / 9 + rowOffset;
            AdvancedTagSlot resourceSlot = slots.get(i);
            Platform.INSTANCE.setSlotY((Slot)resourceSlot, y + 18 + row * 18 + 1 - this.topPos);
            resourceSlot.setActive(resourceSlot.y + this.topPos >= this.getCheckboxStartY() - 18 && resourceSlot.y + this.topPos < this.getCheckboxStartY() + 90 && visible);
        }
    }

    private static int getOverflowRows(AdvancedTag advancedTag) {
        return Math.ceilDiv(advancedTag.getResources().size() - 9, 9);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        int x = this.getCheckboxStartX();
        int y = this.getCheckboxStartY();
        graphics.enableScissor(x, y, x + 194, y + 90);
        int currentY = y - (this.scrollbar != null ? (int)this.scrollbar.getOffset() : 0) * (this.scrollbar != null && this.scrollbar.isSmoothScrolling() ? 1 : 18);
        for (int i = 0; i < ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().size(); ++i) {
            currentY += this.renderAdvancedTagBackground(graphics, mouseX, mouseY, i, y, x, currentY);
        }
        this.renderAdvancedTagMainSlots(graphics, mouseX, mouseY);
        this.advancedTagCheckboxes.forEach(c -> c.render(graphics, mouseX, mouseY, delta));
        this.expandButtons.forEach(c -> c.render(graphics, mouseX, mouseY, delta));
        graphics.disableScissor();
    }

    private int renderAdvancedTagBackground(GuiGraphics graphics, int mouseX, int mouseY, int i, int startY, int x, int y) {
        boolean backgroundVisible;
        AdvancedTag advancedTag = ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().get(i);
        if (!advancedTag.isVisible()) {
            return 0;
        }
        int height = 36 + (int)((double)(AdvancedFilterScreen.getOverflowRows(advancedTag) * 18) * advancedTag.getExpandPct());
        boolean bl = backgroundVisible = y >= startY - height && y < startY + 90;
        if (i % 2 == 0 && backgroundVisible) {
            graphics.fill(x, y, x + 194, y + height, 0, -3750202);
        }
        int mainSlotsY = y + 18;
        this.renderMainSlotsBackground(graphics, startY, x, mainSlotsY, advancedTag);
        int overflowSlotsY = y + 36;
        return 36 + this.renderOverflowSlotsBackground(graphics, mouseX, mouseY, startY, x, overflowSlotsY, advancedTag);
    }

    private void renderMainSlotsBackground(GuiGraphics graphics, int startY, int x, int y, AdvancedTag advancedTag) {
        if (y >= startY - 18 && y < startY + 90) {
            for (int col = 0; col < Math.min(advancedTag.getResources().size(), 9); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.blitSprite(Sprites.SLOT, slotX, y, 18, 18);
            }
        }
    }

    private int renderOverflowSlotsBackground(GuiGraphics graphics, int mouseX, int mouseY, int startY, int x, int y, AdvancedTag advancedTag) {
        int rows = AdvancedFilterScreen.getOverflowRows(advancedTag);
        int height = (int)((double)(rows * 18) * advancedTag.getExpandPct());
        if (height == 0) {
            return 0;
        }
        graphics.enableScissor(x, y, x + 162, y + height);
        for (int row = 0; row < rows; ++row) {
            int idx;
            boolean visible;
            int rowY = y + 18 * row;
            boolean bl = visible = rowY >= startY - 18 && rowY < startY + 90;
            if (!visible) continue;
            for (int col = 0; col < 9 && (idx = 9 + row * 9 + col) < advancedTag.getResources().size(); ++col) {
                int slotX = x + 1 + col * 18;
                graphics.blitSprite(Sprites.SLOT, slotX, rowY, 18, 18);
            }
        }
        this.renderSlots(advancedTag.getOverflowSlots(), graphics, mouseX, mouseY);
        graphics.disableScissor();
        return height;
    }

    private void renderAdvancedTagMainSlots(GuiGraphics graphics, int mouseX, int mouseY) {
        for (AdvancedTag advancedTag : ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags()) {
            this.renderSlots(advancedTag.getMainSlots(), graphics, mouseX, mouseY);
        }
    }

    private void renderSlots(List<AdvancedTagSlot> slots, GuiGraphics graphics, int mouseX, int mouseY) {
        for (ResourceSlot resourceSlot : slots) {
            if (!resourceSlot.isActive()) continue;
            ResourceSlotRendering.render((GuiGraphics)graphics, (ResourceSlot)resourceSlot, (int)this.leftPos, (int)this.topPos);
            if (!this.isHovering(resourceSlot.x, resourceSlot.y, 16, 16, mouseX, mouseY)) continue;
            AdvancedFilterScreen.renderSlotHighlight((GuiGraphics)graphics, (int)(this.leftPos + resourceSlot.x), (int)(this.topPos + resourceSlot.y), (int)0);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    private void addConfirmButton(int x, int y) {
        int width = this.font.width((FormattedText)DONE) + 20 + 12;
        ActionButton button = InvokerActionButton.init(this.leftPos + x, this.topPos + y, width, 20, (Component)DONE, btn -> this.tryConfirmAndCloseToParent());
        this.addRenderableWidget((GuiEventListener)button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrollbar != null && this.scrollbar.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean didScrollbar = this.isOverTagArea(mouseX, mouseY) && this.scrollbar != null && this.scrollbar.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        return didScrollbar || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private boolean isOverTagArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.getCheckboxStartX() && mouseX < (double)(this.getCheckboxStartX() + 194) && mouseY >= (double)this.getCheckboxStartY() && mouseY < (double)(this.getCheckboxStartY() + 90);
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    private boolean tryConfirmAndCloseToParent() {
        if (this.parent != null) {
            Minecraft.getInstance().setScreen(this.parent);
            OptionalInt selectedIndex = IntStream.range(0, this.advancedTagCheckboxes.size()).filter(i -> this.advancedTagCheckboxes.get(i).isSelected()).findFirst();
            if (selectedIndex.isPresent()) {
                ResourceTag resourceTag = ((AdvancedFilterContainerMenu)this.getMenu()).getAdvancedTags().get(selectedIndex.getAsInt()).getTag();
                Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetAdvancedFilterPacket(this.slotIndex, Optional.of(resourceTag)));
            } else {
                Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetAdvancedFilterPacket(this.slotIndex, Optional.empty()));
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.tryClose(key)) {
            return true;
        }
        if (this.searchField != null && (this.searchField.keyPressed(key, scanCode, modifiers) || this.searchField.canConsumeInput())) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private boolean tryClose(int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    private void close() {
        if (!this.tryConfirmAndCloseToParent()) {
            this.onClose();
        }
    }

    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

