/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlockEntity;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TieredAutocrafterBlock
extends AbstractActiveColoredDirectionalBlock<Direction, TieredAutocrafterBlock, BaseBlockItem>
implements EntityBlock,
BlockItemProvider<BaseBlockItem> {
    private static final Component HELP_1 = IdentifierUtil.createTranslation((String)"item", (String)"autocrafter.help");
    private static final Component HELP_2 = CableTiersIdentifierUtil.createCableTiersTranslation("item", "tiered_autocrafter.help");
    private final AbstractBlockEntityTicker<TieredAutocrafterBlockEntity> ticker;
    private final CableTiers tier;

    public TieredAutocrafterBlock(DyeColor color, MutableComponent name, CableTiers tier) {
        super(BlockConstants.PROPERTIES, color, name);
        this.tier = tier;
        this.ticker = new NetworkNodeBlockEntityTicker(() -> BlockEntities.INSTANCE.getTieredAutocrafters(tier), ACTIVE);
    }

    protected DirectionType<Direction> getDirectionType() {
        return DefaultDirectionType.FACE_CLICKED;
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return this.ticker.get(level, type);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TieredAutocrafterBlockEntity(this.tier, pos, state);
    }

    public BlockColorMap<TieredAutocrafterBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getTieredAutocrafters(this.tier);
    }

    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, null){

            public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
                return Optional.of(new HelpTooltipComponent((Component)Component.empty().append(HELP_1).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)HELP_2.getString(), (Object[])new Object[]{Component.literal((String)(TieredAutocrafterBlock.this.tier.getSpeed(CableType.AUTOCRAFTER) + "x")), Component.literal((String)String.valueOf(TieredAutocrafterBlock.this.tier.getFilterSlotsCount()))}))));
            }
        };
    }

    public boolean canAlwaysConnect() {
        return true;
    }
}

