/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceExportState;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.iface.TieredInterfaceBlockEntity;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class ExportedResourcesContainer
extends ResourceContainerImpl
implements InterfaceExportState {
    private final FilterWithFuzzyMode filter;

    ExportedResourcesContainer(CableTiers tier, int size, FilterWithFuzzyMode filter) {
        super(size, resource -> TieredInterfaceBlockEntity.getTransferQuota(tier, resource), RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
        this.filter = filter;
    }

    public int getSlots() {
        return this.size();
    }

    public Collection<ResourceKey> expandExportCandidates(RootStorage rootStorage, ResourceKey resource) {
        if (!this.filter.isFuzzyMode()) {
            return Collections.singletonList(resource);
        }
        if (!(rootStorage instanceof FuzzyRootStorage)) {
            return Collections.singletonList(resource);
        }
        FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
        return fuzzyRootStorage.getFuzzy(resource);
    }

    public boolean isExportedResourceValid(ResourceKey want, ResourceKey got) {
        if (!this.filter.isFuzzyMode()) {
            return got.equals((Object)want);
        }
        ResourceKey normalizedGot = this.normalize(got);
        ResourceKey normalizedWant = this.normalize(want);
        return normalizedGot.equals((Object)normalizedWant);
    }

    private ResourceKey normalize(ResourceKey resource) {
        if (resource instanceof FuzzyModeNormalizer) {
            FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)resource;
            return normalizer.normalize();
        }
        return resource;
    }

    @Nullable
    public ResourceKey getRequestedResource(int slotIndex) {
        return this.filter.getFilterContainer().getResource(slotIndex);
    }

    public long getRequestedAmount(int slotIndex) {
        return this.filter.getFilterContainer().getAmount(slotIndex);
    }

    @Nullable
    public ResourceKey getExportedResource(int slotIndex) {
        return this.getResource(slotIndex);
    }

    public long getExportedAmount(int slotIndex) {
        return this.getAmount(slotIndex);
    }

    public void setExportSlot(int slotIndex, ResourceKey resource, long amount) {
        this.set(slotIndex, new ResourceAmount(resource, amount));
    }

    public void shrinkExportedAmount(int slotIndex, long amount) {
        this.shrink(slotIndex, amount);
    }

    public void growExportedAmount(int slotIndex, long amount) {
        this.grow(slotIndex, amount);
    }

    public long insert(ResourceKey resource, long amount, Action action) {
        CoreValidations.validateNotNull((Object)resource, (String)"Resource to insert must not be null.");
        CoreValidations.validateLargerThanZero((long)amount, (String)"Amount to insert must be larger than zero.");
        if (!(resource instanceof PlatformResourceKey)) {
            return 0L;
        }
        PlatformResourceKey platformResource = (PlatformResourceKey)resource;
        long remainder = amount;
        for (int i = 0; i < this.size(); ++i) {
            ResourceAmount slot = this.get(i);
            if (slot == null) {
                remainder -= this.insertIntoEmptySlot(i, platformResource, action, remainder);
            } else if (slot.resource().equals((Object)resource)) {
                remainder -= this.insertIntoExistingSlot(i, platformResource, action, remainder, slot);
            }
            if (remainder == 0L) break;
        }
        return amount - remainder;
    }

    private long insertIntoEmptySlot(int slotIndex, PlatformResourceKey resource, Action action, long amount) {
        long inserted = Math.min(Math.max(this.getMaxAmount((ResourceKey)resource), resource.getInterfaceExportLimit()), amount);
        if (action == Action.EXECUTE) {
            this.set(slotIndex, new ResourceAmount((ResourceKey)resource, inserted));
        }
        return inserted;
    }

    private long insertIntoExistingSlot(int slotIndex, PlatformResourceKey resource, Action action, long amount, ResourceAmount existing) {
        long spaceRemaining = Math.max(this.getMaxAmount((ResourceKey)resource), resource.getInterfaceExportLimit()) - existing.amount();
        long inserted = Math.min(spaceRemaining, amount);
        if (action == Action.EXECUTE) {
            this.grow(slotIndex, inserted);
        }
        return inserted;
    }
}

