/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.mixin;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridBlockEntity;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.ultramega.cabletiers.common.autocrafting.sidedinput.SidedResourceAmount;
import com.ultramega.cabletiers.common.packet.c2s.SetSidedResourcesOnPatternGridBlockPacket;
import com.ultramega.cabletiers.common.packet.s2c.ClearSidedResourceOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.packet.s2c.ReplaceSidedResourceOnPatternGridMenuPacket;
import com.ultramega.cabletiers.common.utils.ClearableSidedResource;
import com.ultramega.cabletiers.common.utils.PlayerInventoryGetter;
import com.ultramega.cabletiers.common.utils.SidedInput;
import com.ultramega.cabletiers.common.utils.SidedInputUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternGridContainerMenu.class})
public abstract class MixinPatternGridContainerMenu
extends AbstractGridContainerMenu
implements SidedInput,
ClearableSidedResource,
PlayerInventoryGetter {
    @Shadow(remap=false)
    @Nullable
    private PatternGridBlockEntity patternGrid;
    @Unique
    private List<Optional<SidedResourceAmount>> cabletiers$sidedResources = new ArrayList<Optional<SidedResourceAmount>>();

    protected MixinPatternGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, GridData gridData) {
        super(menuType, syncId, playerInventory, gridData);
    }

    @Inject(method={"sendClear"}, at={@At(value="HEAD")}, remap=false)
    private void sendClear(CallbackInfo ci) {
        this.cabletiers$clearSidedResources();
    }

    @Inject(method={"transferProcessingRecipe"}, at={@At(value="HEAD")}, remap=false)
    private void transferProcessingRecipe(CallbackInfo ci) {
        Player player;
        if (this.patternGrid == null) {
            this.cabletiers$clearSidedResources();
            return;
        }
        if (this.player != null && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Platform.INSTANCE.sendPacketToClient(serverPlayer, (CustomPacketPayload)new ClearSidedResourceOnPatternGridMenuPacket());
        }
    }

    @Override
    @Unique
    public void cabletiers$clearSidedResources() {
        this.cabletiers$sidedResources.replaceAll(ignored -> Optional.empty());
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetSidedResourcesOnPatternGridBlockPacket(this.cabletiers$sidedResources));
    }

    @Override
    @Unique
    public void cabletiers$setSidedResources(List<Optional<SidedResourceAmount>> sidedResources) {
        this.cabletiers$sidedResources = sidedResources;
    }

    @Override
    @Unique
    public void cabletiers$replaceSidedResource(@Nullable ResourceAmount resource, int index) {
        if (this.cabletiers$sidedResources.size() > index) {
            Optional<SidedResourceAmount> resourceAmount = this.cabletiers$sidedResources.get(index);
            resourceAmount.ifPresent(ignored -> this.cabletiers$sidedResources.set(index, resource == null ? Optional.empty() : Optional.of(new SidedResourceAmount(resource, ((SidedResourceAmount)resourceAmount.get()).resource().resource().equals((Object)resource.resource()) ? ((SidedResourceAmount)resourceAmount.get()).inputDirection() : Optional.empty()))));
        }
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SetSidedResourcesOnPatternGridBlockPacket(this.cabletiers$sidedResources));
    }

    @Override
    @Unique
    public List<Optional<SidedResourceAmount>> cabletiers$getSidedResources() {
        return this.cabletiers$sidedResources;
    }

    public void handleResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        super.handleResourceSlotChange(slotIndex, tryAlternatives);
        this.cabletiers$handleResourceSlotUpdate(slotIndex);
    }

    public void handleResourceSlotAmountChange(int slotIndex, long amount) {
        super.handleResourceSlotAmountChange(slotIndex, amount);
        this.cabletiers$handleResourceSlotUpdate(slotIndex);
    }

    @Unique
    public void cabletiers$handleResourceSlotUpdate(int slotIndex) {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        int index = 0;
        for (ResourceSlot slot : this.getResourceSlots()) {
            if (!SidedInputUtil.isProcessingInputSlot(slot)) continue;
            if (slot.index == slotIndex) {
                ResourceAmount resourceAmount = slot.getResource() != null ? new ResourceAmount((ResourceKey)slot.getResource(), slot.getAmount()) : null;
                Platform.INSTANCE.sendPacketToClient(serverPlayer, (CustomPacketPayload)new ReplaceSidedResourceOnPatternGridMenuPacket(Optional.ofNullable(resourceAmount), index));
                break;
            }
            ++index;
        }
    }

    @Override
    public Inventory cabletiers$getPlayerInventory() {
        return this.playerInventory;
    }
}

