/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.datagen;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.registry.Blocks;
import com.ultramega.cabletiers.common.utils.CableTiersIdentifierUtil;
import com.ultramega.cabletiers.common.utils.ContentIds;
import com.ultramega.cabletiers.neoforge.datagen.TieredColoredCustomLoaderBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockModelProviderImpl
extends BlockModelProvider {
    private static final String PARTICLE_TEXTURE = "particle";
    private static final String CUTOUT_TEXTURE = "cutout";
    private static final String ALL_TEXTURE = "all";
    private static final ResourceLocation TIERED_AUTOCRAFTER = CableTiersIdentifierUtil.createCableTiersIdentifier("block/tiered_autocrafter");
    private static final ResourceLocation EMISSIVE_NORTH_CUTOUT = IdentifierUtil.createIdentifier((String)"block/emissive_north_cutout");
    private static final ResourceLocation CUBE_ALL = ResourceLocation.withDefaultNamespace((String)"block/cube_all");
    private static final ResourceLocation NORTH_CUTOUT = IdentifierUtil.createIdentifier((String)"block/north_cutout");
    private static final String CUTOUT_NORTH_COLOR = "cutout_north_color";
    private static final String CUTOUT_EAST_COLOR = "cutout_east_color";
    private static final String CUTOUT_SOUTH_COLOR = "cutout_south_color";
    private static final String CUTOUT_WEST_COLOR = "cutout_west_color";
    private static final String CUTOUT_UP_COLOR = "cutout_up_color";
    private static final String CUTOUT_NORTH_TIER = "cutout_north_tier";
    private static final String CUTOUT_EAST_TIER = "cutout_east_tier";
    private static final String CUTOUT_SOUTH_TIER = "cutout_south_tier";
    private static final String CUTOUT_WEST_TIER = "cutout_west_tier";
    private static final String CUTOUT_UP_TIER = "cutout_up_tier";
    private static final String NORTH = "north";
    private static final String EAST = "east";
    private static final String SOUTH = "south";
    private static final String WEST = "west";
    private static final String UP = "up";
    private static final String DOWN = "down";

    public BlockModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "cabletiers", existingFileHelper);
    }

    protected void registerModels() {
        for (CableTiers tier : CableTiers.values()) {
            this.registerTieredDiskInterfaces(tier);
            this.registerTieredAutocrafters(tier);
            this.registerTieredInterfaces(tier);
        }
    }

    private void registerTieredDiskInterfaces(CableTiers tier) {
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getTieredDiskInterfaces(tier), "disk_interface", "base_", tier);
        Blocks.INSTANCE.getTieredDiskInterfaces(tier).forEach((color, id, block) -> ((TieredColoredCustomLoaderBuilder)((BlockModelBuilder)this.getBuilder("block/" + tier.getLowercaseName() + "_disk_interface/" + color.getName())).customLoader((blockModelBuilder, existingFileHelper) -> new TieredColoredCustomLoaderBuilder<BlockModelBuilder>(this, ContentIds.getContentId(tier, CableType.DISK_INTERFACE), blockModelBuilder, existingFileHelper, color, tier){})).end());
    }

    private void registerTieredAutocrafters(CableTiers tier) {
        ResourceLocation side = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/side");
        ResourceLocation top = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/top");
        ResourceLocation bottom = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/bottom");
        Blocks.INSTANCE.getTieredAutocrafters(tier).forEach((color, id, autocrafter) -> {
            ResourceLocation cutoutSideColor = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_color/" + color.getName());
            ResourceLocation cutoutSideTier = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_tier/" + tier.getLowercaseName());
            ResourceLocation cutoutTopColor = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_color/" + color.getName());
            ResourceLocation cutoutTopTier = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_tier/" + tier.getLowercaseName());
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + tier.getLowercaseName() + "_autocrafter/" + color.getName(), TIERED_AUTOCRAFTER)).texture(PARTICLE_TEXTURE, side)).texture(NORTH, side)).texture(EAST, side)).texture(SOUTH, side)).texture(WEST, side)).texture(UP, top)).texture(DOWN, bottom)).texture(CUTOUT_NORTH_COLOR, cutoutSideColor)).texture(CUTOUT_EAST_COLOR, cutoutSideColor)).texture(CUTOUT_SOUTH_COLOR, cutoutSideColor)).texture(CUTOUT_WEST_COLOR, cutoutSideColor)).texture(CUTOUT_UP_COLOR, cutoutTopColor)).texture(CUTOUT_NORTH_TIER, cutoutSideTier)).texture(CUTOUT_EAST_TIER, cutoutSideTier)).texture(CUTOUT_SOUTH_TIER, cutoutSideTier)).texture(CUTOUT_WEST_TIER, cutoutSideTier)).texture(CUTOUT_UP_TIER, cutoutTopTier);
        });
        ResourceLocation cutoutSideColor = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_color/inactive");
        ResourceLocation cutoutSideTier = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/side_tier/" + tier.getLowercaseName());
        ResourceLocation cutoutTopColor = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_color/inactive");
        ResourceLocation cutoutTopTier = CableTiersIdentifierUtil.createCableTiersIdentifier("block/autocrafter/cutouts/top_tier/" + tier.getLowercaseName());
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + tier.getLowercaseName() + "_autocrafter/inactive", TIERED_AUTOCRAFTER)).texture(PARTICLE_TEXTURE, side)).texture(NORTH, side)).texture(EAST, side)).texture(SOUTH, side)).texture(WEST, side)).texture(UP, top)).texture(DOWN, bottom)).texture(CUTOUT_NORTH_COLOR, cutoutSideColor)).texture(CUTOUT_EAST_COLOR, cutoutSideColor)).texture(CUTOUT_SOUTH_COLOR, cutoutSideColor)).texture(CUTOUT_WEST_COLOR, cutoutSideColor)).texture(CUTOUT_UP_COLOR, cutoutTopColor)).texture(CUTOUT_NORTH_TIER, cutoutSideTier)).texture(CUTOUT_EAST_TIER, cutoutSideTier)).texture(CUTOUT_SOUTH_TIER, cutoutSideTier)).texture(CUTOUT_WEST_TIER, cutoutSideTier)).texture(CUTOUT_UP_TIER, cutoutTopTier);
    }

    private void registerTieredInterfaces(CableTiers tier) {
        ResourceLocation activeAll = CableTiersIdentifierUtil.createCableTiersIdentifier("block/interface/" + tier.getLowercaseName() + "_active");
        ResourceLocation inactiveAll = CableTiersIdentifierUtil.createCableTiersIdentifier("block/interface/" + tier.getLowercaseName() + "_inactive");
        ((BlockModelBuilder)this.withExistingParent("block/" + tier.getLowercaseName() + "_interface/active", CUBE_ALL)).texture(ALL_TEXTURE, activeAll);
        ((BlockModelBuilder)this.withExistingParent("block/" + tier.getLowercaseName() + "_interface/inactive", CUBE_ALL)).texture(ALL_TEXTURE, inactiveAll);
    }

    private void registerRightLeftBackFrontTopModel(BlockColorMap<?, ?> blockMap, String name, String modelPrefix, CableTiers tier) {
        blockMap.forEach((color, id, block) -> {
            ResourceLocation cutout = IdentifierUtil.createIdentifier((String)("block/" + name + "/cutouts/" + color.getName()));
            this.registerRightLeftBackFrontTopModel(name, modelPrefix + color.getName(), cutout, EMISSIVE_NORTH_CUTOUT, false, tier);
        });
        ResourceLocation inactiveCutout = IdentifierUtil.createIdentifier((String)("block/" + name + "/cutouts/inactive"));
        this.registerRightLeftBackFrontTopModel(name, "inactive", inactiveCutout, NORTH_CUTOUT, true, tier);
    }

    private void registerRightLeftBackFrontTopModel(String name, String variantName, ResourceLocation cutout, ResourceLocation baseModel, boolean inactive, CableTiers tier) {
        ResourceLocation side = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/side");
        ResourceLocation front = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/" + tier.getLowercaseName() + "_front" + (inactive ? "_inactive" : ""));
        ResourceLocation top = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/top");
        ResourceLocation bottom = CableTiersIdentifierUtil.createCableTiersIdentifier("block/" + name + "/bottom");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/" + tier.getLowercaseName() + "_" + name + "/" + variantName, baseModel)).texture(PARTICLE_TEXTURE, side)).texture(NORTH, front)).texture(EAST, side)).texture(SOUTH, side)).texture(WEST, side)).texture(UP, top)).texture(DOWN, bottom)).texture(CUTOUT_TEXTURE, cutout);
    }
}

