/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.creeperhost.polylib.client.model.Model3D;
import net.creeperhost.polylib.client.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class RenderResizableCuboid {
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;
    protected EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();

    private static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
        if (axis == Direction.Axis.X) {
            return new Vector3f(value, vector.y(), vector.z());
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(vector.x(), value, vector.z());
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(vector.x(), vector.y(), value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + String.valueOf(vector) + ")");
    }

    public static double getValue(Vector3d vector, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return vector.x;
        }
        if (axis == Direction.Axis.Y) {
            return vector.y;
        }
        if (axis == Direction.Axis.Z) {
            return vector.z;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + String.valueOf(vector) + ")");
    }

    public void renderCube(Model3D cube, PoseStack matrix, VertexConsumer buffer, int argb, int light) {
        float red = RenderUtils.getRed(argb);
        float green = RenderUtils.getGreen(argb);
        float blue = RenderUtils.getBlue(argb);
        float alpha = RenderUtils.getAlpha(argb);
        Vector3d size = new Vector3d(cube.sizeX(), cube.sizeY(), cube.sizeZ());
        matrix.pushPose();
        matrix.translate(cube.minX, cube.minY, cube.minZ);
        Matrix4f matrix4f = matrix.last().pose();
        for (Direction face : Direction.values()) {
            int ordinal;
            TextureAtlasSprite sprite;
            if (!cube.shouldSideRender(face) || (sprite = cube.textures[ordinal = face.ordinal()]) == null) continue;
            Direction.Axis u = face.getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction.Axis v = face.getAxis() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
            float other = face.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (float)RenderResizableCuboid.getValue(size, face.getAxis()) : 0.0f;
            face = face.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? face : face.getOpposite();
            Direction opposite = face.getOpposite();
            float minU = sprite.getU0();
            float maxU = sprite.getU1();
            float minV = sprite.getV1();
            float maxV = sprite.getV0();
            double sizeU = RenderResizableCuboid.getValue(size, u);
            double sizeV = RenderResizableCuboid.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    addU = sizeU - (double)uIndex;
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        addV = sizeV - (double)vIndex;
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.popPose();
    }

    private void renderPoint(Matrix4f matrix4f, VertexConsumer buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light) {
        int uFinal = minU ? 0 : 1;
        int vFinal = minV ? 2 : 3;
        Vector3f vertex = RenderResizableCuboid.withValue(VEC_ZERO, u, xyz[uFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, v, xyz[vFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, face.getAxis(), other);
        buffer.addVertex(matrix4f, vertex.x(), vertex.y(), vertex.z()).setColor(red, green, blue, alpha).setUv(uv[uFinal], uv[vFinal]).setLight(light);
    }
}

