/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.screen.widget.buttons;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.creeperhost.polylib.client.screen.widget.buttons.PolyButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class DropdownButton<E extends IDropdownOption>
extends PolyButton {
    public boolean dropdownOpen;
    private E selected;
    private List<E> possibleVals;
    private Component baseButtonText;
    private final boolean dynamic;
    private final boolean drawHeader;
    public boolean wasJustClosed = false;
    Minecraft minecraft = Minecraft.getInstance();
    public boolean flipped = false;

    public DropdownButton(int x, int y, int widthIn, int heightIn, Component buttonText, E def, boolean dynamic, boolean drawHeader, Button.OnPress onPress) {
        super(x, y, widthIn, heightIn, buttonText, onPress, DEFAULT_NARRATION);
        this.selected = def;
        this.possibleVals = def.getPossibleVals();
        this.baseButtonText = buttonText;
        this.dynamic = dynamic;
        this.drawHeader = drawHeader;
    }

    public DropdownButton(int x, int y, int widthIn, int heightIn, Component buttonText, E def, boolean dynamic, Button.OnPress onPress) {
        this(x, y, widthIn, heightIn, buttonText, def, dynamic, true, onPress);
    }

    public DropdownButton(int x, int y, Component buttonText, E def, boolean dynamic, Button.OnPress onPress) {
        this(x, y, 200, 20, buttonText, def, dynamic, onPress);
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int drawY = this.getY();
            Font fontrenderer = this.minecraft.font;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = mouseX >= this.getX() && mouseY >= drawY && mouseX < this.getX() + this.width && mouseY < drawY + this.height;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (this.drawHeader) {
                guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
                int j = 0xE0E0E0;
                if (!this.active) {
                    j = 0xA0A0A0;
                } else if (this.isHovered) {
                    j = 0xFFFFA0;
                }
                guiGraphics.drawCenteredString(fontrenderer, this.baseButtonText, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j);
            }
            if (this.dropdownOpen) {
                ++drawY;
                int yOffset = this.height - 2;
                if (this.flipped) {
                    yOffset = -yOffset;
                    --drawY;
                }
                int possibleValsSize = this.possibleVals.size();
                for (int j = 0; j < possibleValsSize; ++j) {
                    IDropdownOption e = (IDropdownOption)this.possibleVals.get(j);
                    boolean ourHovered = mouseX >= this.getX() && mouseY >= (drawY += yOffset) && mouseX < this.getX() + this.width && mouseY < drawY + this.height - 2;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    guiGraphics.blitSprite(SPRITES.get(this.active, ourHovered), this.getX(), drawY, this.getWidth(), this.getHeight());
                    String name = I18n.get((String)e.getTranslate((IDropdownOption)this.selected, true), (Object[])new Object[0]);
                    int textColour = 0xE0E0E0;
                    guiGraphics.drawCenteredString(fontrenderer, name, this.getX() + this.width / 2, drawY + (this.height - 10) / 2, textColour);
                }
            }
        }
    }

    protected int getHoverState(boolean mouseOver) {
        return mouseOver ? 2 : (this.active ? (this.dropdownOpen ? 2 : 1) : 0);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        boolean pressed = super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (this.dropdownOpen) {
            if (this.drawHeader && pressed) {
                this.close();
                return false;
            }
            E clickedElement = this.getClickedElement(p_mouseClicked_1_, p_mouseClicked_3_);
            if (clickedElement != null) {
                this.setSelected(clickedElement);
                try {
                    this.ourOnPress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.close();
                return true;
            }
            this.close();
            return false;
        }
        if (pressed && this.drawHeader) {
            this.dropdownOpen = true;
            if (this.dynamic) {
                this.selected.updateDynamic();
                this.possibleVals = this.selected.getPossibleVals();
            }
        }
        return false;
    }

    public void ourOnPress() {
    }

    public void onPress() {
    }

    public void close() {
        this.dropdownOpen = false;
        this.wasJustClosed = true;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        try {
            this.selected = selected;
            this.updateDisplayString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDisplayString() {
        this.baseButtonText = Component.translatable((String)this.selected.getTranslate((IDropdownOption)this.selected, false), (Object[])new Object[]{this.baseButtonText});
    }

    private E getClickedElement(double mouseX, double mouseY) {
        IDropdownOption clickedElement = null;
        int y = this.getY() + 1;
        int yOffset = this.height - 2;
        if (this.flipped) {
            yOffset = -yOffset;
            --y;
        }
        for (IDropdownOption e : this.possibleVals) {
            y += yOffset;
            if (!(mouseX >= (double)this.getX()) || !(mouseY >= (double)y) || !(mouseX < (double)(this.getX() + this.width)) || !(mouseY < (double)(y + this.height - 2))) continue;
            clickedElement = e;
            break;
        }
        return (E)clickedElement;
    }

    public List<E> getPossibleVals() {
        return this.possibleVals;
    }

    public static interface IDropdownOption {
        public List<IDropdownOption> getPossibleVals();

        public String getTranslate(IDropdownOption var1, boolean var2);

        default public void updateDynamic() {
        }
    }
}

