/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum BookDisplayMode implements StringRepresentable
{
    NODE("node"),
    INDEX("index");

    public static final StringRepresentable.EnumCodec<BookDisplayMode> CODEC;
    private static final IntFunction<BookDisplayMode> BY_ID;
    public static final StreamCodec<ByteBuf, BookDisplayMode> STREAM_CODEC;
    private final String name;

    private BookDisplayMode(String name) {
        this.name = name;
    }

    public static BookDisplayMode byName(String pName) {
        return (BookDisplayMode)CODEC.byName(pName);
    }

    public static BookDisplayMode byId(int pId) {
        return BY_ID.apply(pId);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(BookDisplayMode::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])BookDisplayMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

