/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book.markdown;

import com.klikli_dev.modonomicon.client.gui.book.markdown.ComponentNodeRendererContext;
import com.klikli_dev.modonomicon.client.gui.book.markdown.LinkRenderer;
import com.klikli_dev.modonomicon.client.gui.book.markdown.internal.renderer.BulletListHolder;
import com.klikli_dev.modonomicon.client.gui.book.markdown.internal.renderer.ListHolder;
import com.klikli_dev.modonomicon.client.gui.book.markdown.internal.renderer.OrderedListHolder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Block;
import org.commonmark.node.BulletList;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.renderer.NodeRenderer;

public class CoreComponentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final ComponentNodeRendererContext context;

    public CoreComponentNodeRenderer(ComponentNodeRendererContext context) {
        this.context = context;
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        ObjectOpenHashSet classes = new ObjectOpenHashSet(Arrays.asList(Document.class, Heading.class, Paragraph.class, BulletList.class, Link.class, ListItem.class, OrderedList.class, Emphasis.class, StrongEmphasis.class, Text.class, SoftLineBreak.class, HardLineBreak.class));
        classes.trim();
        return classes;
    }

    public void render(Node node) {
        node.accept((Visitor)this);
    }

    public void visit(BulletList bulletList) {
        ListItem item;
        this.context.setListHolder(new BulletListHolder(this.context.getListHolder(), bulletList));
        this.visitChildren((Node)bulletList);
        if (this.context.getListHolder().getParent() != null) {
            this.context.setListHolder(this.context.getListHolder().getParent());
        } else {
            this.context.setListHolder(null);
        }
        Block block = bulletList.getParent();
        if (!(block instanceof ListItem) || !((item = (ListItem)block).getNext() instanceof ListItem)) {
            this.context.finalizeCurrentComponent();
        }
    }

    public void visit(Emphasis emphasis) {
        boolean italic = this.context.getCurrentStyle().isItalic();
        this.context.setCurrentStyle(this.context.getCurrentStyle().withItalic(Boolean.valueOf(true)));
        this.visitChildren((Node)emphasis);
        this.context.setCurrentStyle(this.context.getCurrentStyle().withItalic(Boolean.valueOf(italic)));
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.context.getCurrentComponent().append((Component)Component.literal((String)"\n"));
        this.visitChildren((Node)hardLineBreak);
    }

    public void visit(Link link) {
        for (LinkRenderer renderer : this.context.getLinkRenderers()) {
            if (!renderer.visit(link, this::visitChildren, this.context)) continue;
            return;
        }
        TextColor currentColor = this.context.getCurrentStyle().getColor();
        MutableComponent hoverComponent = Component.translatable((String)"modonomicon.gui.hover.http_link", (Object[])new Object[]{link.getDestination()});
        this.context.setCurrentStyle(this.context.getCurrentStyle().withColor(currentColor == null ? this.context.getLinkColor() : currentColor).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link.getDestination())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoverComponent)));
        this.visitChildren((Node)link);
        this.context.setCurrentStyle(this.context.getCurrentStyle().withColor(currentColor).withClickEvent(null).withHoverEvent(null));
    }

    public void visit(ListItem listItem) {
        this.context.finalizeCurrentComponent();
        ListHolder listHolder = this.context.getListHolder();
        if (listHolder != null && listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)listHolder;
            this.context.getCurrentComponent().append((Component)Component.translatable((String)(orderedListHolder.getIndent() + orderedListHolder.getCounter() + orderedListHolder.getDelimiter() + " ")).withStyle(Style.EMPTY).withStyle(s -> s.withFont(this.context.getCurrentStyle().getFont())));
            this.visitChildren((Node)listItem);
            orderedListHolder.increaseCounter();
        } else if (listHolder != null && listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)listHolder;
            this.context.getCurrentComponent().append((Component)Component.translatable((String)(bulletListHolder.getIndent() + bulletListHolder.getMarker() + " ")).withStyle(Style.EMPTY).withStyle(s -> s.withFont(this.context.getCurrentStyle().getFont())));
            this.visitChildren((Node)listItem);
        }
    }

    public void visit(OrderedList orderedList) {
        ListItem item;
        this.context.setListHolder(new OrderedListHolder(this.context.getListHolder(), orderedList));
        this.visitChildren((Node)orderedList);
        if (this.context.getListHolder().getParent() != null) {
            this.context.setListHolder(this.context.getListHolder().getParent());
        } else {
            this.context.setListHolder(null);
        }
        Block block = orderedList.getParent();
        if (!(block instanceof ListItem) || !((item = (ListItem)block).getNext() instanceof ListItem)) {
            this.context.finalizeCurrentComponent();
        }
    }

    public void visit(SoftLineBreak softLineBreak) {
        if (this.context.getRenderSoftLineBreaks()) {
            this.context.getCurrentComponent().append("\n");
        } else if (this.context.getReplaceSoftLineBreaksWithSpace()) {
            this.context.getCurrentComponent().append((Component)Component.literal((String)" "));
        }
        this.visitChildren((Node)softLineBreak);
    }

    public void visit(StrongEmphasis strongEmphasis) {
        boolean emphasis = this.context.getCurrentStyle().isBold();
        this.context.setCurrentStyle(this.context.getCurrentStyle().withBold(Boolean.valueOf(true)));
        this.visitChildren((Node)strongEmphasis);
        this.context.setCurrentStyle(this.context.getCurrentStyle().withBold(Boolean.valueOf(emphasis)));
    }

    public void visit(Text text) {
        this.context.getCurrentComponent().append((Component)Component.translatable((String)text.getLiteral()).withStyle(this.context.getCurrentStyle()));
        this.visitChildren((Node)text);
    }

    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

