/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.config;

import io.github.frqnny.mostructures.config.StructureConfigEntry;
import io.github.frqnny.omegaconfig.api.Comment;
import io.github.frqnny.omegaconfig.api.Config;
import java.util.HashMap;
import java.util.Map;

public class MoStructuresConfig
implements Config {
    @Comment(value=" Welcome to Mo'Structures Config!\n\n   Take a break, rest a while, enjoy the scenery! :)\n\n   Using this config, you can:\n   - Prevent structures from generating by de-activating them.\n   - Modify values used in calculating structure locations to modify their chance to generate.\n\n   You can modify the biomes these structures spawn in through datapacks.\n\n   Structures use two numbers to determine structure locations:\n   - Separation is the minimum chunk distance between structures of that type.\n   - Spacing is the average chunk distance between structures of that type.\n   Modifying these values can shift the chances a structure generates.\n\n   If you have any questions, please join my discord available in our CurseForge page.\n\n")
    protected final Map<String, StructureConfigEntry> structureConfigEntries = new HashMap<String, StructureConfigEntry>();

    public String getName() {
        return "mostructures-config-v5";
    }

    public String getExtension() {
        return "json5";
    }

    public StructureConfigEntry get(String configKey) {
        return this.structureConfigEntries.get(configKey);
    }

    public void save() {
        this.putIfAbsent("abandoned_church", 20, 33);
        this.putIfAbsent("air_balloon", 12, 22);
        this.putIfAbsent("barn_house", 16, 32);
        this.putIfAbsent("big_pyramid", 25, 32);
        this.putIfAbsent("ice_tower", 20, 28);
        this.putIfAbsent("jungle_pyramid", 22, 25);
        this.putIfAbsent("killer_bunny_castle", 22, 32);
        this.putIfAbsent("lighthouse", 14, 24);
        this.putIfAbsent("moai", 15, 17);
        this.putIfAbsent("pillager_factory", 16, 34);
        this.putIfAbsent("pillager_mines", 27, 40);
        this.putIfAbsent("pirate_ship", 16, 32);
        this.putIfAbsent("tavern", 16, 26);
        this.putIfAbsent("the_castle_in_the_sky", 22, 32);
        this.putIfAbsent("villager_market", 16, 32);
        this.putIfAbsent("villager_tower", 16, 26);
        this.putIfAbsent("sphinx", 16, 24);
        super.save();
    }

    private void putIfAbsent(String configKey, int defaultSeparation, int defaultSpacing) {
        this.structureConfigEntries.putIfAbsent(configKey, StructureConfigEntry.of(defaultSeparation, defaultSpacing));
    }
}

