/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.crafting.OutputResolver;
import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessTagRecipe
extends ShapelessRecipe {
    private final OutputResolver outputResolver;
    private ItemStack result;

    public ShapelessTagRecipe(String group, CraftingBookCategory category, NonNullList<Ingredient> inputs, OutputResolver outputResolver) {
        super(group, category, ItemStack.EMPTY, inputs);
        this.outputResolver = outputResolver;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookup) {
        if (this.result == null) {
            this.result = this.outputResolver.resolve();
        }
        return this.result;
    }

    public boolean isSpecial() {
        if (this.result == null) {
            this.result = this.outputResolver.resolve();
        }
        return this.result.isEmpty();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPELESS_TAG.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessTagRecipe> {
        public static final MapCodec<ShapelessTagRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)OutputResolver.Tag.CODEC.fieldOf("result").forGetter(recipe -> (OutputResolver.Tag)recipe.outputResolver)).apply((Applicative)builder, ShapelessTagRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessTagRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapelessTagRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessTagRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessTagRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            int size = buffer.readVarInt();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            OutputResolver.Item result = OutputResolver.create(buffer);
            return new ShapelessTagRecipe(group, category, (NonNullList<Ingredient>)ingredients, result);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapelessTagRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.outputResolver.resolve());
            buffer.writeBoolean(recipe.showNotification());
        }
    }
}

