/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.world.inventory.ContainerData;

public class ContainerDataBuilder {
    private final List<DataSlotGetterSetter> data = new ArrayList<DataSlotGetterSetter>();

    private ContainerDataBuilder() {
    }

    public static ContainerDataBuilder builder() {
        return new ContainerDataBuilder();
    }

    public ContainerDataBuilder sync(IntSupplier getter, IntConsumer setter) {
        this.data.add(new DataSlotGetterSetter(getter, setter));
        return this;
    }

    public ContainerData build() {
        return new ContainerData(){
            private final List<DataSlotGetterSetter> data;
            {
                this.data = ContainerDataBuilder.this.data;
            }

            public int get(int index) {
                return this.data.get((int)index).getter.getAsInt();
            }

            public void set(int index, int value) {
                this.data.get((int)index).setter.accept(value);
            }

            public int getCount() {
                return this.data.size();
            }
        };
    }

    record DataSlotGetterSetter(IntSupplier getter, IntConsumer setter) {
    }
}

