/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.monster.boss.ForgottenGuardian;

public class ForgottenGuardianModel<T extends ForgottenGuardian>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public ForgottenGuardianModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftArm = this.body.getChild("leftArm");
        this.rightArm = this.body.getChild("rightArm");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(48, 11).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(48, 45).addBox(-3.0f, -14.0f, -3.0f, 6.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(41, 69).addBox(-3.0f, -13.0f, -5.0f, 6.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(76, 0).addBox(-3.0f, -13.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(42, 0).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-14.0f, (float)1.0f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-14.0f, (float)6.0f));
        PartDefinition torso = chest.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -9.0f, -9.0f, 16.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(64, 60).addBox(-7.0f, -2.0f, -4.0f, 7.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 73).addBox(-5.0f, 6.0f, -3.0f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(28, 19).addBox(-6.0f, 18.0f, -4.0f, 6.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(56, 23).addBox(0.0f, -2.0f, -4.0f, 7.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(72, 39).addBox(1.0f, 6.0f, -3.0f, 4.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(0.0f, 18.0f, -4.0f, 6.0f, 18.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)-19.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(67, 76).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(24, 45).addBox(-4.0f, 11.0f, -3.0f, 6.0f, 22.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-9.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(20, 73).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(-2.0f, 11.0f, -3.0f, 6.0f, 22.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftLeg.xRot = -1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.rightLeg.xRot = 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f) * limbSwingAmount;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int attackTimer = ((ForgottenGuardian)((Object)entity)).getAttackTimer();
        if (attackTimer > 0) {
            this.rightArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)attackTimer - partialTicks), (float)10.0f);
            this.leftArm.xRot = -2.0f + 1.5f * Mth.triangleWave((float)((float)attackTimer - partialTicks), (float)10.0f);
        } else {
            this.rightArm.xRot = (-0.2f + 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
            this.leftArm.xRot = (-0.2f - 1.5f * Mth.triangleWave((float)limbSwing, (float)13.0f)) * limbSwingAmount;
        }
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.body, (Object)this.leftLeg, (Object)this.rightLeg);
    }
}

