/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.GreaterDweller;

public class GreaterDwellerModel<T extends GreaterDweller>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart trunk;
    private final ModelPart torso;
    private final ModelPart tail;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public GreaterDwellerModel(ModelPart root) {
        this.head = root.getChild("head");
        this.trunk = this.head.getChild("trunk");
        this.torso = root.getChild("torso");
        this.tail = this.torso.getChild("tail");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-11.0f, (float)-21.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -10.0f, -9.0f, 14.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition trunk = head.addOrReplaceChild("trunk", CubeListBuilder.create().texOffs(0, 21).addBox(-4.0f, -2.0f, -8.0f, 8.0f, 20.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-8.0f));
        PartDefinition cube_r2 = trunk.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 70).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)31.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = trunk.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 50).addBox(-3.0f, -2.0f, -4.0f, 6.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-13.6242f, (float)-7.7995f));
        PartDefinition cube_r4 = torso.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(104, 45).addBox(-2.0f, -12.0f, -8.0f, 4.0f, 16.0f, 37.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.3758f, (float)-12.2005f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = torso.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 50).addBox(-10.0f, -5.0f, -16.0f, 20.0f, 16.0f, 32.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.6242f, (float)1.7995f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail = torso.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 98).addBox(-8.0f, 0.0f, -2.0f, 16.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.6242f, (float)17.7995f));
        PartDefinition cube_r6 = tail.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 112).addBox(-4.0f, -2.0f, -1.0f, 8.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(50, 0).mirror().addBox(-2.0f, 19.0f, 5.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)9.0f, (float)-11.0f, (float)-2.0f));
        PartDefinition cube_r7 = leftLeg.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(110, 0).mirror().addBox(-3.0f, -24.0f, -5.0f, 6.0f, 25.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)20.0f, (float)-5.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = leftLeg.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(66, 0).mirror().addBox(-3.0f, -5.0f, -14.0f, 6.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)7.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(50, 0).addBox(-2.0f, 19.0f, 5.0f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.0f, (float)-11.0f, (float)-2.0f));
        PartDefinition cube_r9 = rightLeg.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(110, 0).addBox(-3.0f, -24.0f, -5.0f, 6.0f, 25.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)20.0f, (float)-5.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = rightLeg.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(66, 0).addBox(-3.0f, -5.0f, -14.0f, 6.0f, 5.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)7.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int attackTimer = ((GreaterDweller)((Object)entity)).getAttackTimer();
        if (attackTimer == 0) {
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
            this.head.xRot = 0.1745f + headPitch * ((float)Math.PI / 180);
        }
        this.leftLeg.xRot = -0.2618f + Mth.cos((float)(limbSwing * 0.6662f)) * 0.66f * limbSwingAmount;
        this.rightLeg.xRot = -0.2618f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.66f * limbSwingAmount;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        int attackTimer = ((GreaterDweller)((Object)entity)).getAttackTimer();
        if (attackTimer > 0) {
            this.head.xRot = 1.5f * Mth.triangleWave((float)((float)attackTimer - partialTick), (float)10.0f);
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.torso, (Object)this.rightLeg, (Object)this.leftLeg);
    }
}

