/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.monster.rotspawn.Rotling;

public class RotlingModel<T extends Rotling>
extends ListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public RotlingModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightLeg = this.body.getChild("rightLeg");
        this.leftLeg = this.body.getChild("leftLeg");
        this.rightArm = this.body.getChild("rightArm");
        this.leftArm = this.body.getChild("leftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 17).addBox(-4.0f, -10.5f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, -12.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.5f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -8.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.5f, (float)4.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(24, 2).addBox(0.0f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-3.5f, (float)1.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(24, 2).mirror().addBox(-3.0f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)-3.5f, (float)1.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-10.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.2817f, 0.0977f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-11.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = entity.isAggressive() ? -0.5235f : -0.1745f;
        this.leftArm.xRot = entity.isAggressive() ? -1.5f : Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.xRot = entity.isAggressive() ? -1.5f : Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightArm.zRot = 0.4363f;
        this.leftArm.zRot = -0.4363f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }
}

