/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.event;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import quek.undergarden.component.RogdoriumInfusion;
import quek.undergarden.criterion.UthericInfectionTrigger;
import quek.undergarden.datamap.UthericInfectionLethality;
import quek.undergarden.network.UthericInfectionPacket;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGDataComponents;
import quek.undergarden.registry.UGDataMaps;
import quek.undergarden.registry.UGTags;

public class UthericInfectionEvents {
    public static final double MAX_INFECTION = 20.0;

    protected static void init() {
        NeoForge.EVENT_BUS.addListener(UthericInfectionEvents::tickUthericInfection);
        NeoForge.EVENT_BUS.addListener(UthericInfectionEvents::onEntityHit);
        NeoForge.EVENT_BUS.addListener(UthericInfectionEvents::syncUthericInfectionOnLogin);
        NeoForge.EVENT_BUS.addListener(UthericInfectionEvents::syncUthericInfectionOnDimensionChange);
    }

    private static void tickUthericInfection(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.getAbilities().invulnerable) {
                    return;
                }
            }
            if (livingEntity.tickCount % 20 == 0 && !livingEntity.level().isClientSide() && !livingEntity.getType().is(UGTags.Entities.IMMUNE_TO_INFECTION)) {
                double data = (Double)livingEntity.getData(UGAttachments.UTHERIC_INFECTION);
                if (data >= 20.0) {
                    livingEntity.hurt(livingEntity.damageSources().source(UGDamageSources.UTHERIC_INFECTION), 2.0f);
                } else {
                    UthericInfectionLethality biomeLethality = (UthericInfectionLethality)livingEntity.level().getBiome(livingEntity.blockPosition()).getData(UGDataMaps.BIOME_LETHALITY);
                    float b = biomeLethality == null ? 0.0f : biomeLethality.lethality();
                    int a = 0;
                    if (b > 0.0f) {
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            for (int i = 0; i < 4; ++i) {
                                ItemStack armor = player.getInventory().getArmor(i);
                                int infusionAmount = ((RogdoriumInfusion)armor.getOrDefault(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.DEFAULT)).infusionAmount();
                                if (infusionAmount <= 0) continue;
                                armor.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(infusionAmount - 1));
                                ++a;
                            }
                        }
                        double t = (double)b / ((double)(1 + a) * 0.18);
                        livingEntity.setData(UGAttachments.UTHERIC_INFECTION, (Object)(data + t));
                    } else if (livingEntity.tickCount % 400 == 0 && data > 0.0) {
                        livingEntity.setData(UGAttachments.UTHERIC_INFECTION, (Object)(data - 1.0));
                    } else if (data < 0.0) {
                        livingEntity.setData(UGAttachments.UTHERIC_INFECTION, (Object)0.0);
                    }
                    UthericInfectionEvents.sendInfectionSyncPacket((Entity)livingEntity);
                }
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    ((UthericInfectionTrigger)((Object)UGCriteria.UTHERIC_INFECTION.get())).trigger(player, (Double)livingEntity.getData(UGAttachments.UTHERIC_INFECTION));
                }
            }
        }
    }

    private static void onEntityHit(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        if (entity instanceof LivingEntity && !(livingEntity = entity).level().isClientSide() && !livingEntity.getType().is(UGTags.Entities.IMMUNE_TO_INFECTION)) {
            UthericInfectionLethality entityLethality;
            double data = (Double)livingEntity.getData(UGAttachments.UTHERIC_INFECTION);
            if (event.getSource().getEntity() != null && (entityLethality = (UthericInfectionLethality)event.getSource().getEntity().getType().builtInRegistryHolder().getData(UGDataMaps.ENTITY_LETHALITY)) != null) {
                float b = entityLethality.lethality();
                int a = 0;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    for (int i = 0; i < 4; ++i) {
                        ItemStack armor = player.getInventory().getArmor(i);
                        int infusionAmount = ((RogdoriumInfusion)armor.getOrDefault(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.DEFAULT)).infusionAmount();
                        if (infusionAmount <= 0) continue;
                        armor.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(infusionAmount - 1));
                        ++a;
                    }
                }
                double t = (double)b / ((double)(1 + a) * 0.18);
                livingEntity.setData(UGAttachments.UTHERIC_INFECTION, (Object)(data + t));
                UthericInfectionEvents.sendInfectionSyncPacket((Entity)livingEntity);
            }
        }
    }

    private static void syncUthericInfectionOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            UthericInfectionEvents.sendInfectionSyncPacket((Entity)event.getEntity());
        }
    }

    private static void syncUthericInfectionOnDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            UthericInfectionEvents.sendInfectionSyncPacket((Entity)event.getEntity());
        }
    }

    public static void sendInfectionSyncPacket(Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new UthericInfectionPacket(entity.getId(), (Double)entity.getData(UGAttachments.UTHERIC_INFECTION)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

