/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import quek.undergarden.registry.UGSoundEvents;

public class DitchbulbPasteItem
extends Item {
    public DitchbulbPasteItem() {
        super(new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        boolean success = false;
        if (!(CampfireBlock.canLight((BlockState)state) || CandleBlock.canLight((BlockState)state) || CandleCakeBlock.canLight((BlockState)state))) {
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)(pos = pos.relative(context.getClickedFace())), (Direction)context.getHorizontalDirection())) {
                this.playSound(level, pos);
                level.setBlockAndUpdate(pos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos));
                level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_PLACE, pos);
                success = true;
            }
        } else {
            this.playSound(level, pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE));
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_PLACE, pos);
            success = true;
        }
        if (success) {
            context.getItemInHand().shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    private void playSound(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        level.playSound(null, pos, (SoundEvent)UGSoundEvents.DITCHBULB_PASTE_USE.get(), SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
    }
}

