/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool.slingshot;

import it.unimi.dsi.fastutil.objects.AbstractObject2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.ArrowNockEvent;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.Undergarden;
import quek.undergarden.criterion.SlingshotFireTrigger;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.item.tool.slingshot.AbstractSlingshotAmmoBehavior;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class SlingshotItem
extends ProjectileWeaponItem {
    private static final Map<Item, AbstractSlingshotAmmoBehavior> AMMO_REGISTRY = (Map)Util.make((Object)new Object2ObjectOpenHashMap(), AbstractObject2ObjectFunction::defaultReturnValue);

    public SlingshotItem() {
        super(new Item.Properties().stacksTo(1).durability(192).rarity(Rarity.UNCOMMON));
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 1;
    }

    public int getMaxDamage(ItemStack stack) {
        if (Undergarden.registryAccessStatic() != null) {
            int longevity = stack.getEnchantmentLevel((Holder)Undergarden.registryAccessStatic().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(UGEnchantments.LONGEVITY));
            int durability = super.getMaxDamage(stack);
            if (longevity > 0) {
                return durability * (longevity + 1);
            }
            return durability;
        }
        return super.getMaxDamage(stack);
    }

    public static void registerAmmo(ItemLike item, AbstractSlingshotAmmoBehavior behavior) {
        AMMO_REGISTRY.put(item.asItem(), behavior);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> AMMO_REGISTRY.containsKey(stack.getItem());
    }

    public int getDefaultProjectileRange() {
        return 10;
    }

    protected void shootProjectile(LivingEntity entity, Projectile projectile, int x, float y, float z, float velocity, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, velocity * 2.0f, 1.0f);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean isCreative = player.getAbilities().instabuild;
            ItemStack projectileStack = player.getProjectile(stack);
            boolean selfSling = stack.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(UGEnchantments.SELF_SLING)) > 0;
            int useTime = this.getUseDuration(stack, (LivingEntity)player) - timeLeft;
            if ((useTime = SlingshotItem.onArrowLoose(stack, level, player, useTime, !projectileStack.isEmpty() || isCreative || selfSling)) < 0) {
                return;
            }
            float velocity = SlingshotItem.getProjectileVelocity(useTime);
            if (selfSling) {
                if (!player.onGround()) {
                    return;
                }
                Vec3 delta = player.getLookAngle();
                player.push(delta.x * (double)(velocity * 2.0f), delta.y * (double)velocity + (double)(velocity / 2.0f), delta.z * (double)(velocity * 2.0f));
                if (!level.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)UGSoundEvents.SLINGSHOT_SHOOT.get(), SoundSource.PLAYERS, 0.5f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (!projectileStack.isEmpty() && !selfSling) {
                if (projectileStack.is(Items.ARROW)) {
                    projectileStack = new ItemStack((ItemLike)UGItems.DEPTHROCK_PEBBLE.get());
                }
                if (!((double)velocity < 0.1)) {
                    if (!level.isClientSide) {
                        SlingshotProjectile slingshotProjectile = AMMO_REGISTRY.get(projectileStack.getItem()).getProjectile(level, entity.blockPosition(), player, projectileStack);
                        slingshotProjectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity * 2.0f, 1.0f);
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                        int ricochet = stack.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(UGEnchantments.RICOCHET));
                        if (ricochet > 0) {
                            slingshotProjectile.setRicochetTimes(ricochet + 1);
                        }
                        level.addFreshEntity((Entity)slingshotProjectile);
                        level.playSound(null, player.getX(), player.getY(), player.getZ(), AMMO_REGISTRY.get(projectileStack.getItem()).getFiringSound(), SoundSource.PLAYERS, 0.5f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                        ((SlingshotFireTrigger)((Object)UGCriteria.SLINGSHOT_FIRE.get())).trigger((ServerPlayer)player, stack, projectileStack);
                    }
                    AMMO_REGISTRY.get(projectileStack.getItem()).addAdditionalFiringEffects(level, player);
                    if (!isCreative) {
                        projectileStack.shrink(1);
                        if (projectileStack.isEmpty()) {
                            player.getInventory().removeItem(projectileStack);
                        }
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        boolean hasAmmo = !player.getProjectile(stack).isEmpty();
        boolean selfSling = stack.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(UGEnchantments.SELF_SLING)) > 0;
        InteractionResultHolder<ItemStack> ret = SlingshotItem.onArrowNock(stack, level, player, hand, hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!(player.getAbilities().instabuild || hasAmmo || selfSling)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)UGSoundEvents.SLINGSHOT_DRAW.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        return InteractionResultHolder.consume((Object)stack);
    }

    public static InteractionResultHolder<ItemStack> onArrowNock(ItemStack stack, Level level, Player player, InteractionHand hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, stack, hand, level, hasAmmo);
        if (((ArrowNockEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return event.getAction();
    }

    public static int onArrowLoose(ItemStack stack, Level level, Player player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, level, charge, hasAmmo);
        if (((ArrowLooseEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return -1;
        }
        return event.getCharge();
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.is(ItemTags.PLANKS);
    }
}

